<!DOCTYPE html>
<html lang="es-pe">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->

<!-- favicon -->
<link rel="shortcut icon" href="img/favicon.png">
<!-- Bootstrap -->
<link rel="stylesheet" href="css/bootstrap.min.css">
<!-- Bootstrap Select -->
<link rel="stylesheet" href="css/bootstrap-select.min.css">
<!-- main css -->
<link rel="stylesheet" href="css/main.css">

<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
<!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->

<!-- EN CADA PÁGINA ############################# -->
<title>SEMINARIO UDEP - DIRECCIÓN ESTRATÉGICA PARA INSTITUCIONES EDUCATIVAS | Admisión UDEP</title>
<!-- Basic HTML Meta Tags -->
<meta name='title' content='' />
<meta name='description' content='' />
<meta name='url' content='' />
<meta name='keywords' content='' />
<!-- OpenGraph Meta Tags -->
<meta property="og:type" content='website' />
<meta property='og:title' content='' />
<meta property='og:description' content='' />
<meta property='og:url' content='' />
<meta property='og:image' content='' />
<!-- ############################################ -->
</head>
<body>

<!-- <script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');
  ga('create', 'UA-55699707-1', 'auto');
  ga('send', 'pageview');
</script> -->



<header>
  <img class="img-responsive hidden-xs" src="img/web/banner-desktop.jpg" alt="imagen">
  <img class="img-responsive visible-xs" src="http://placehold.it/767x600" alt="imagen">
</header>



<section id="intro" class="py-seccion bg-celeste blanco    bg-img-cover">
  <div class="container">
    <div class="row text-center">
      <div class="col-lg-8 col-lg-offset-2">
        <div class="lead">
          <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc diam est, elementum sit amet maximus sit amet, rhoncus ut quam. Nullam nec commodo lacus.</p>
          <p>Donec vestibulum ut diam eget rutrum. Aenean imperdiet elit purus, nec hendrerit eros imperdiet eu.</p>
        </div>
      </div>
    </div>
  </div>
</section>



<section id="confirma" class="py-seccion bg-blanco gris">
  <div class="container">
    <div class="row text-center">
      <div class="col-lg-8 col-lg-offset-2">
        <h2 class="titulo text-center amarillo">CONFIRMA TU ASISTENCIA</h2>
      </div>
      
      <div class="col-lg-10 col-lg-offset-1">
        <div class="text-center mb-5">
          <p class="lead mb-2">Hasta 2 asistentes por colegio (Director y un invitado)</p>
          <p>*En caso requerir una vacante adicional por favor contactar con su Gestora de Canal. Vacantes limitadas.</p>
        </div>
        
        <form id="formulario" class="" method="post" action="">
          <div class="row">
            <div class="col-sm-6">
              <div class="form-group">
                <input type="text" class="form-control" name="asistente" placeholder="Nombre y Apellidos">
              </div>
            </div>

            <div class="col-sm-6">
              <div class="form-group">
                <input type="text" class="form-control" name="correo" placeholder="Correo electrónico">
              </div>
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-sm-6">
              <div class="form-group">
                <select class="form-control selectpicker" id="cargo" name="cargo" title="Seleccione su Cargo">
                  <option value="Director(a)">Director(a)</option>
                  <option value="Orientador(a) Vocacional">Orientador(a) Vocacional</option>
                  <option value="Psicologo(a)">Psicólogo(a)</option>
                  <option value="Docente">Docente</option>
                </select>
              </div>
            </div>
            
            <div class="col-sm-6">
              <div class="form-group">
                <select class="form-control selectpicker" id="colegio" name="colegio" title="Colegio">
                  <option value="Abraham Lincoln">Abraham Lincoln</option>
                  <option value="Alexander Von Humboldt">Alexander Von Humboldt</option>
                  <option value="Alpamayo">Alpamayo</option>
                  <option value="Altair">Altair</option>
                  <option value="América del Callao">América del Callao</option>
                  <option value="Antares">Antares</option>
                  <option value="Antonio Raimondi">Antonio Raimondi</option>
                  <option value="Augusto Weberbauer">Augusto Weberbauer</option>
                  <option value="Cambridge College">Cambridge College</option>
                  <option value="Casuarinas College">Casuarinas College</option>
                  <option value="Champagnat">Champagnat</option>
                  <option value="Claretiano">Claretiano</option>
                  <option value="Cooperativo la Unión">Cooperativo la Unión</option>
                  <option value="Cristo salvador">Cristo salvador</option>
                  <option value="De la Inmaculada">De la Inmaculada</option>                                                
                  <option value="Euroamericano">Euroamericano</option>
                  <option value="Franco Peruano">Franco Peruano</option>
                  <option value="Franklin D. Roosevelt">Franklin D. Roosevelt</option>
                  <option value="Hans Christian Andersen">Hans Christian Andersen</option>
                  <option value="Hiram Bingham">Hiram Bingham</option>
                  <option value="Humtec">Humtec</option>
                  <option value="Isabel Flores de Oliva">Isabel Flores de Oliva</option>
                  <option value="La Inmaculada Concepción">La Inmaculada Concepción</option>
                  <option value="Leon Pinelo">León Pinelo</option>
                  <option value="Leonardo Da Vinci">Leonardo Da Vinci</option>
                  <option value="Liceo Naval Almarirante Guise">Liceo Naval Almarirante Guise</option>
                  <option value="Los Alamos">Los Álamos</option>
                  <option value="Magister">Magister</option>
                  <option value="María Alvarado">María Alvarado</option>
                  <option value="María de los Ángeles">María de los Ángeles</option>
                  <option value="María Molinari">María Molinari</option>
                  <option value="María Reina Marianistas">María Reina Marianistas</option>
                  <option value="Markham College">Markham College</option>
                  <option value="Mater Admirabilis">Mater Admirabilis</option>
                  <option value="Mater Purissima">Mater Purissima</option>
                  <option value="Miravalles">Miravalles</option>
                  <option value="Montealto">Montealto</option> 
                  <option value="Newton College">Newton College</option>                                                
                  <option value="Nivel A">Nivel A</option>                                                      
                  <option value="Nuestra Señora del Carmen">Nuestra Señora del Carmen (Carmelitas)</option>
                  <option value="Peruano Británico">Peruano Británico</option>
                  <option value="Peruano Chino Juan XXIII">Peruano Chino Juan XXIII</option>
                  <option value="Pestalozzi">Pestalozzi</option>
                  <option value="Regina Pacis">Regina Pacis</option>
                  <option value="Reina de los Ángeles">Reina de los Ángeles</option>
                  <option value="Reina del Mundo">Reina del Mundo</option>
                  <option value="S.C. Belen">S.C. Belen</option>
                  <option value="S.C. Recoleta">S.C. Recoleta</option>
                  <option value="S.C. Sophianum">S.C. Sophianum</option>
                  <option value="Salcantay">Salcantay</option>
                  <option value="San Agustín">San Agustín</option>
                  <option value="San Antonio de Padua">San Antonio de Padua</option>
                  <option value="San Charbel">San Charbel</option>
                  <option value="San Charbel">San Ignacio de Recalde</option>
                  <option value="San José de Cluny - Barranco">San José de Cluny - Barranco</option>
                  <option value="San José de Cluny - Surquillo">San José de Cluny - Surquillo</option> 
                  <option value="San José de Monterrico">San José de Monterrico</option>
                  <option value="San Pedro">San Pedro</option>
                  <option value="San Silvestre School">San Silvestre School</option>
                  <option value="Santa Margarita">Santa Margarita</option>
                  <option value="Santa María Marianistas">Santa María Marianistas</option>
                  <option value="Santa Rita de Casia">Santa Rita de Casia</option>
                  <option value="Santa Teresita">Santa Teresita</option>
                  <option value="Santa Úrsula">Santa Úrsula</option>
                  <option value="Santísimo Nombre de Jesús">Santísimo Nombre de Jesús</option>
                  <option value="ST. George´s College">ST. George´s College</option>
                  <option value="Trener">Trener</option>
                  <option value="Villa Alarife">Villa Alarife</option>
                  <option value="Villa Caritas">Villa Caritas</option>
                  <option value="Villa María la Planicie">Villa María la Planicie</option>
                </select>
              </div>
            </div>
          </div>

          <div class="center-block">
            <input type="button" id="btn_enviar" name="login" class="boton" value="ENVIAR" style="cursor:pointer;">
            <div id="respuesta"></div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>



<section id="programa" class="py-seccion bg-gris-claro gris-oscuro">
  <div class="container">
    <h2 class="titulo text-center amarillo">PROGRAMA</h2>
    
    <table class="table">
      <thead>
        <tr>
          <th>HORA</th>
          <th>SESIÓN</th>
          <th>EXPOSITORES</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td><strong>8:00 a.m.</strong></td>
          <td>
            <strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</strong>
            <br>Lorem ipsum dolor sit amet
          </td>
          <td>Expositor</td>
        </tr>
        <tr>
          <td><strong>10:00 a.m.</strong></td>
          <td>
            <strong>Nunc diam est, elementum sit amet maximus sit amet.</strong>
            <br>Sit amet maximus sit amet.
          </td>
          <td>Expositor</td>
        </tr>
        <tr>
          <td><strong>12:00 m.</strong></td>
          <td>
            <strong>Rhoncus ut quam. Nullam nec commodo lacus.</strong>
            <br>Nullam nec commodo lacus.
          </td>
          <td>Expositor</td>
        </tr>
        <tr>
          <td><strong>2:00 p.m.</strong></td>
          <td>
            <strong>Donec vestibulum ut diam eget rutrum.</strong>
            <br>Nullam nec commodo lacus.
          </td>
          <td>Expositor</td>
        </tr>
        <tr>
          <td><strong>4:00 p.m.</strong></td>
          <td>
            <strong>Aenean imperdiet elit purus, nec hendrerit eros imperdiet eu.</strong>
            <br>Nullam nec commodo lacus.
          </td>
          <td>Expositor</td>
        </tr>
      </tbody>
    </table>
  </div>
</section>



<section id="expositores" class="py-seccion bg-gris-oscuro blanco">
  <div class="container">
    <h2 class="titulo text-center amarillo">EXPOSITORES</h2>

    <div class="row">
      <div class="col-xs-12 col-sm-4 col-md-4">
        <div class="container-autoridades">
          <div class="autoridades">
            <img class="center-block img-responsive" src="http://placehold.it/360x400">
            <div class="over">
              <div class="over-padre">
                <div class="over-celda">
                  <div>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Corporis aliquam reprehenderit sequi in animi obcaecati sit, itaque rerum delectus tempore error quos repudiandae. Accusamus quaerat quia cupiditate maiores fugit ipsa.</div>
                  <div>Omnis, corporis alias reprehenderit sit aperiam expedita repellat repellendus libero nesciunt ducimus voluptatibus magni a odio excepturi voluptates consectetur aliquam temporibus, id consequatur cupiditate deserunt optio nihil, assumenda est. Quis.</div>
                  <div>Quasi optio inventore, eos. Minus in eius impedit corporis non officiis recusandae, odio sunt ad qui aliquid minima praesentium perferendis cum ex soluta odit expedita doloribus repellat, atque labore architecto.</div>
                </div>
              </div>
            </div>
          </div>
          <br>
          <div class="nombre">Ph.D. Francisco Arbaiza</div>
          <div class="cargo"></div>
        </div>
      </div>

      <div class="col-xs-12 col-sm-4 col-md-4">
        <div class="container-autoridades">
          <div class="autoridades">
            <img class="center-block img-responsive" src="http://placehold.it/360x400">
            <div class="over">
              <div class="over-padre">
                <div class="over-celda">
                  <div>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Porro possimus sit facilis, voluptates nemo, libero maxime est rem doloribus odio vero in iste laudantium nostrum asperiores consectetur neque perferendis culpa.</div>
                  <div>Expedita commodi nostrum et, praesentium animi, sint repudiandae impedit natus harum ipsam provident! Officia, ratione porro illo, quasi fugiat doloremque nulla, voluptatibus deserunt assumenda numquam modi magnam dolores! Voluptate, nostrum.</div>
                  <div>Perspiciatis quo laboriosam, consectetur, est commodi veniam praesentium expedita error ipsam inventore, suscipit sunt eius. Perferendis laudantium molestiae, delectus. Totam ea quaerat voluptatum voluptate eveniet. Architecto cum perspiciatis corporis dolore.</div>
                </div>
              </div>
            </div>
          </div>
          <br>
          <div class="nombre">Ph.D. Francisco Arbaiza</div>
          <div class="cargo"></div>
        </div>
      </div>

      <div class="col-xs-12 col-sm-4 col-md-4">
        <div class="container-autoridades">
          <div class="autoridades">
            <img class="center-block img-responsive" src="http://placehold.it/360x400">
            <div class="over">
              <div class="over-padre">
                <div class="over-celda">
                  <div>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Veniam suscipit nihil culpa labore itaque! Unde provident nisi nam quaerat distinctio itaque, est nostrum esse repellendus ex aut ratione libero ipsum.</div>
                  <div>Doloremque soluta, ab dignissimos, vero harum optio laudantium in facere id repellat tempore reprehenderit tenetur aliquid, velit a. Velit earum est non laboriosam, aliquam debitis maiores dolor dolorem delectus. Nemo.</div>
                  <div>Eius molestias, aperiam illum non dolore laborum omnis porro quo, quis illo culpa nemo, architecto, explicabo nostrum praesentium quidem perspiciatis qui dolores delectus ipsum veniam quod officiis ratione. Unde, hic.</div>
                </div>
              </div>
            </div>
          </div>
          <br>
          <div class="nombre">Ph.D. Francisco Arbaiza</div>
          <div class="cargo"></div>
        </div>
      </div>                           
    </div>
  </div>
</section>



<footer>
	<div class="container">
		Universidad de Piura - Todos los derechos reservados 2019
	</div>
</footer>



<?php include "include/disclaimer.php"; ?>



<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<!--<script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>-->
<!-- Include all compiled plugins (below), or include individual files as needed -->
<script src="js/bootstrap.min.js"></script>
<!-- Bootstrap Select -->
<script src="js/bootstrap-select.min.js"></script>

<!--Plug-in Initialisation-->
 <script type="text/javascript">
 /* $(function() {
    $(".expand").on( "click", function() {
      $expand = $(this).find(">:first-child");
      
      if($expand.text() == "▼") {
        $expand.text("▲");
      } else {
        $expand.text("▼");
      }
    });*/
    
  $("#btn_enviar").click(function(){
    var url = "send.php"; // El script a dónde se realizará la petición.
    $("#respuesta").html("Procesando, espere por favor...");
    $("#btn_enviar").css("display", "none");
    $.ajax({
      type: "POST",
      url: url,
      data: $("#formulario").serialize(), // Adjuntar los campos del formulario enviado.
      success: function(data){
        ncantidad = data.length;
        //alert(ncantidad);
        if ( ncantidad <= "10"){
            $("#respuesta").html("<span style='color:#3C0'>Tus datos han sido guardados correctamente!</span>");
            $(".form-control").val("");
            $("#btn_enviar").css("display", "inline-block");

            $('#cargo').selectpicker('val', '' );
            $('#colegio').selectpicker('val', '' );
           // $("#cargo option[value=Seleccione]").attr("selected",true);
           // $("input[name='cargo'] ").attr("selected",true);
        }else{
          //$("#respuesta").html("<span style='color:#000'>"+data+"</span>"); // Mostrar la respuestas del script PHP.
          $("#respuesta").html(data);
          $("#btn_enviar").css("display", "inline-block");
        }
      }
    });
    return false; // Evitar ejecutar el submit del formulario.
  });
</script> 
    
</body>
</html>