<?php 
    include 'include/head.php';
    $suscripcion="true";
?>
    <title>INNOVAPUCP | Servicios de Laboratorio</title>
    <!-- Basic HTML Meta Tags -->
    <meta name='title' content='INNOVAPUCP | Servicios de Laboratorio' />
    <meta name='description' content='Los laboratorios de Departamentos Académicos, Institutos y Centros de la PUCP, están dedicados a la formación académica, desarrollo de proyectos de investigación y a la mejora del sector productivo, el Estado y la sociedad.'
    />
    <meta property='og:url' content='<?php echo $host; ?>servicios-de-laboratorio.php' />
    <meta name='keywords' content='INNOVAPUCP, Acústica, Centro de Caracterización de Materiales, Centro de Tecnologías Avanzadas de Manufactura, Corrosión y Protección, Electricidad y Electrónica, Energía, Estructuras Antisísmicas, Ingeniería de Minas, Instituto de Ciencias Ómicas y Biotecnología Aplicada, Manufactura, Materiales, Mecánica de Suelos, Resonancia Magnética Nuclear' />
    <!-- OpenGraph Meta Tags -->
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Servicios de Laboratorio' />
    <meta property='og:description' content='Los laboratorios de Departamentos Académicos, Institutos y Centros de la PUCP, están dedicados a la formación académica, desarrollo de proyectos de investigación y a la mejora del sector productivo, el Estado y la sociedad.'
    />
    <meta property='og:url' content='<?php echo $host; ?>servicios-de-laboratorio.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body>
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio" />
    <?php include 'include/menu.php';?>

    <div class="container-texto-menu laboratorio">
        <div class="texto-menu">
            <div class="container">Servicios de Laboratorio</div>
        </div>
    </div>

    <div id="laboratorio">
        <div class="container padding_section">
            <div class="servicio-introductorio">
                <div class="row">
                    <div class="col-xs-12 titulo-xs">
                        <h1 class="visible-xs-block">Servicios de Laboratorio</h1>
                    </div>
                </div>
                <div class="row">
                    <div class="hidden-xs col-sm-2">
                        <img class="img-responsive" src="img/ensayos_principal.png" alt="">
                    </div>
                    <div class="col-sm-10">
                        <p>Los laboratorios de Departamentos Académicos, Institutos y Centros de la PUCP, están dedicados a la formación académica, desarrollo de proyectos de investigación y a la mejora del sector productivo, el Estado y la sociedad.</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="container padding_section frase-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <h2 class="titulo-servicio">TECNOLOGÍA QUE CREA VALOR</h2>
                </div>
            </div>
        </div>

        <div class="container padding_section">
            <div class="row">
                <div class="col-sm-12">
                    <h3 class="titulo-servicio">LISTA DE LABORATORIOS</h3>
                </div>
            </div>
        </div>

        <div class="separador-bottom">
            <div class="container">
                <div class="row    row--flex-center">
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-acustica.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/01-laboratorio-de-acustica.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Acústica</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-centro-de-caracterizacion-de-materiales.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/02-laboratorio-de-centro-de-caracterizacion-de-materiales.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Centro de Caracterización de Materiales</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="centro-de-tecnologias-avanzadas-de-manufactura.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/03-centro-de-tecnologias-avanzadas-de-manufactura.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Centro de Tecnologías Avanzadas de Manufactura</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-corrosion-proteccion.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/04-laboratorio-corrosion-proteccion.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Corrosión y Protección</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-electricidad-y-electronica.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/05-laboratorio-de-electricidad-y-electronica.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Electricidad y Electrónica</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-energia.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/06-laboratorio-de-energia.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Energía</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-estructuras-antisismicas.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/07-laboratorio-de-estructuras-antisismicas.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Estructuras Antisísmicas</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-ingenieria-de-minas.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/08-laboratorio-de-ingenieria-de-minas.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Ingeniería de Minas</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-del-instituto-de-ciencias-omicas-y-biotecnologia-aplicada.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/09-laboratorio-del-instituto-de-ciencias-omicas-y-biotecnologia-aplicada.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Instituto de Ciencias Ómicas y Biotecnología Aplicada</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-manufacturas.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/10-laboratorio-de-manufacturas.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Manufactura</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-materiales.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/11-laboratorio-de-materiales.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Materiales</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-mecanica-de-suelos.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/12-laboratorio-de-mecanica-de-suelos.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Mecánica de Suelos</h3>
                            </div>
                        </a>
                    </div>
                    <div class="col-xss-12 col-xs-6 col-md-4">
                        <a href="laboratorio-de-resonancia-magnetica-nuclear.php">
                            <div class="caja-img-velo-txt">
                                <div class="caja-img-velo-txt__img" style="background-image: url(img/servicios-de-laboratorio/13-laboratorio-de-resonancia-magnetica-nuclear.jpg);"></div>
                                <div class="caja-img-velo-txt__velo"></div>
                                <h3 class="caja-img-velo-txt__h">Resonancia Magnética Nuclear</h3>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include 'include/footer.php';?>
</body>

</html>
