<?php 
    include 'include/head.php';

?>
    <title>INNOVAPUCP | Laboratorio de Resonancia Magnética Nuclear</title>
    <meta name='title' content='INNOVAPUCP | Laboratorio de Resonancia Magnética Nuclear' />  
    <meta name='description' content='El Laboratorio de Resonancia Magnética Nuclear (RMN) ofrece servicios, de rutina o especializados, que contribuyen a la investigación, la docencia y la industria que se desarrolla en el país. Estos servicios permiten abordar la determinación estructural de un compuesto o una mezcla y monitorear procesos químicos y bioquímicos diversos. Asimismo, se ofrece asesoría a empresas, universidades e institutos sobre el análisis y la interpretación de los espectros.' />
    <meta name='url' content='<?php echo $host; ?>laboratorio-de-resonancia-magnetica-nuclear.php' />
    <meta name='keywords' content='INNOVAPUCP,Laboratorio de Resonancia Magnética Nuclear,servicios de rutina, servicios especializados, investigación,contribución a la docencia' />   
    <!-- OpenGraph Meta Tags --> 
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio de Resonancia Magnética Nuclear' />
    <meta property='og:description' content='El Laboratorio de Resonancia Magnética Nuclear (RMN) ofrece servicios, de rutina o especializados, que contribuyen a la investigación, la docencia y la industria que se desarrolla en el país. Estos servicios permiten abordar la determinación estructural de un compuesto o una mezcla y monitorear procesos químicos y bioquímicos diversos. Asimismo, se ofrece asesoría a empresas, universidades e institutos sobre el análisis y la interpretación de los espectros.' />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-resonancia-magnetica-nuclear.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio"/>
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorio de Resonancia Magnética Nuclear</div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 separador-top titulo-xs">
                    <h1 class="visible-xs-block">Laboratorio de Resonancia Magnética Nuclear</h1>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <p>El Laboratorio de Resonancia Magnética Nuclear (RMN) ofrece servicios, de rutina o especializados, que contribuyen a la investigación, la docencia y el sector productivo que se desarrolla en el país. Estos servicios permiten abordar la determinación estructural de un compuesto o una mezcla y monitorear procesos químicos y bioquímicos diversos. Asimismo, ofrecen asesoría a empresas, universidades e institutos sobre el análisis y la interpretación de los espectros.</p>
            <p>Este laboratorio cuenta con 2 tipos de ensayos acreditados por INACAL según NTP-ISO/IEC 17025:2006.</p>
            <ul>
                <li>Análisis de resonancia magnética nuclear bidimensional de compuestos solubles (RMN - Lab - 3.03)</li>
                <li>Análisis de resonancia magnética nuclear monodimensional de compuestos solubles (RMN - Lab -3.02)</li>
            </ul>
            <br>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <h3>Los principales métodos de ensayo de rutina son:</h3>
                    <ul>
                        <li> Análisis mono-dimensional protón (1H) y carbono (13C).</li>
                        <li> Experimentos bi-dimensional y multi-pulsos. (1D-DEPT, 2D-COSY, 2D-NOESY, 2D-TOCSY, 2D-HSQC, 2D-HMBC, 3D-TOCSY-HSQC, 4D-HMQC-NOESY-HMQC, DOSY).</li>
                        <li> Análisis mono-dimensional y bidimensional de otros núcleos de interés como: 2H, 3He, 7Li, 10B, 11B, 15N, 19F, 23Na, 29Si, 31P, 33S,35Cl, 37Cl, 39K, 47Ti, 49Ti, 79Br, 81Br, 95Mo, 87Rb, 195Pt, 129.</li>
                    </ul>                        
                </div>
                <div class="col-sm-12 col-md-6  container-border">
                    <h3>Este laboratorio puede realizar:</h3>                        
                    <ul>
                        <li> Cuantificación y determinación de estructuras moleculares.</li>
                        <li> Cuantificación y determinación estructural de impurezas, contaminantes y/o adulterantes.</li>
                        <li> Monitoreo de reacciones químicas y bioquímicas.</li>
                        <li> Determinación de equilibrios químicos, análisis conformacionales, constantes de afinidad, parámetros termodinámicos y estereoquímica.</li>
                        <li> Control de calidad: Pureza de los insumos, de los productos, de los solventes y otros.</li>
                        <li> Análisis de hidrocarburos (gasolina, diésel, kerosene y otros) y polímeros industriales (poliéster, polipropileno (PP), silicona, poliuretano (PU), polietileno (PE), policloruro de vinilo (PVC) y otros).</li>
                        <li> Análisis de productos agropecuarios (grasas, aceites comestibles, jugos, bebidas alcohólicas y colorantes naturales, cereales, carne, leche, vegetales, café, vainilla y otros).</li>
                        <li> Determinación de perfiles metabolómicos.</li>
                        <li> Capacitación en tecnologías avanzadas de manufactura (PLC, manufactura asistida por computadora, diseño asistido por computadora, control numérico computarizado).</li>
                    </ul>      
                </div>
            </div>  
        </div>
    </div>
     
    <div class="container padding_section">  
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios del laboratorio <a href="contacto.php">aquí</a></p>
                    <br>
                     <div id="lista-contacto-dt-lab">
                     <dl class="titulo"><dt>Contacto</dt><dd></dd></dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/05.png" alt="" /></dt>
                        <dd>
                            <strong>Dra. Helena Maruenda Castillo</strong><br>
                            Jefe del Laboratorio<br>
                            Departamento de Ciencias - Sección de Química
                        </dd>                  
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/02.png" alt="" /></dt>
                        <dd> (01) 626-2000 anexo 4226 | 4235
                        </dd>                  
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/03.png" alt="" /></dt>
                        <dd><a href="mailto:hmaruen@pucp.edu.pe">hmaruen@pucp.edu.pe</a> / <a href="mailto:jmlopez@pucp.edu.pe">jmlopez@pucp.edu.pe</a></dd>        
                      </dl>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                <!-- Wrapper for slides -->
                <div class="carousel-inner" role="listbox">
                    <div class="item active">

                        <a href="#modal_1" class="openform"><img src="img/resonancia/01.jpg" alt="innovapucp laboratorio resonancia magnetica nuclear 01" /></a>
                        <div id="modal_1" class="form">
                            <img class="center-block img-responsive"  src="img/resonancia/01.jpg" alt="innovapucp laboratorio resonancia magnetica nuclear 01" />
                            <p>Espectrómetro BRUKER ASCEND  500 MHz con portador de muestras</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Espectrómetro BRUKER ASCEND  500 MHz con portador de muestras</p>                               
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_2" class="openform"><img src="img/resonancia/02.jpg"  alt="innovapucp laboratorio resonancia magnetica nuclear 02" /></a>
                        <div id="modal_2" class="form">
                            <img class="center-block img-responsive"  src="img/resonancia/02.jpg"  alt="innovapucp laboratorio resonancia magnetica nuclear 02" />                               
                             <p>Espectrómetro BRUKER ASCEND 500 MHz con consola AVANCE III HD</p>
                        </div>

                        <div class="carousel-caption">    
                             <p>Espectrómetro BRUKER ASCEND 500 MHz con consola AVANCE III HD</p>
                        </div>
                    </div>                       
                </div>

                <ol class="carousel-indicators">
                    <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                </ol>
                    <!-- Left and right controls -->
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">
                    <img src="img/left.png" alt="" />
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">
                    <img src="img/right.png" alt="" />
                </a>
            </div>
        </div> 
    </div>

    <?php include 'include/otros_laboratorios.php';?>      
    <?php include 'include/footer.php';?>    
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
    <!-- Add mousewheel plugin (this is optional) -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>

    <script>
        $(document).ready(function(){
          $('.fancybox').fancybox();
          $(".openform").fancybox();
        });
    </script>
</body>
</html>
