<?php 
    include 'include/head.php';
    include("admin/config.php");
?>
    <title>INNOVAPUCP | Laboratorio de Materiales</title>
    <meta name='title' content='INNOVAPUCP | Laboratorio de Materiales' />  
    <meta name='description' content='El Laboratorio de Materiales cuenta con más de 40 años de experiencia brindando servicios en el campo de los materiales, con personal altamente capacitado y certificado a nivel internacional. La constante renovación de la infraestructura y el equipamiento han permitido que el Laboratorio se posicione como uno de los más reconocidos y de mayor prestigio, no solo a nivel nacional, sino también a nivel latino americano.' />
    <meta name='url' content='<?php echo $host; ?>laboratorio-de-materiales.php' />
    <meta name='keywords' content='INNOVAPUCP,Laboratorio de Materiales, 40 años de experiencia,servicios en el campo de los materiales,altamente capacitado,certificado a nivel internacional,personal altamente capacitado,personal certificado a nivel internacional' />   
    <!-- OpenGraph Meta Tags --> 
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio de Materiales' />
    <meta property='og:description' content='El Laboratorio de Materiales cuenta con más de 40 años de experiencia brindando servicios en el campo de los materiales, con personal altamente capacitado y certificado a nivel internacional. La constante renovación de la infraestructura y el equipamiento han permitido que el Laboratorio se posicione como uno de los más reconocidos y de mayor prestigio, no solo a nivel nacional, sino también a nivel latino americano.' />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-materiales.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio"/>
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorio de Materiales</div>
        </div>
    </div>
  
    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 separador-top titulo-xs">
                    <h1 class="visible-xs-block">Laboratorio de Materiales</h1>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <p>El CITE Materiales cuenta con más de 40 años de experiencia en el campo de los materiales, con docentes altamente capacitados y certificados a nivel internacional. El Laboratorio se ha posicionado como uno de los más reconocidos y de mayor prestigio, no solo a nivel nacional, sino también a nivel latinoamericano.</p>
            <p>Este laboratorio cuenta con 5 tipos de ensayos acreditados por INACAL según NTP-ISO/IEC 17025:2006.</p>
            <ul>
                <li>Determinación de tamaño de grano promedio (ASTM E 112-13)</li>
                <li>Ensayo de dureza   (ASTM E10-18, ASTM E18-19, ASTM E92-17 y ASTM F606M – 16a y ASTM F606.2016.)</li>
                <li>Ensayo de impacto con muesca (ASTM E 23-18 Charpy-v)</li>
                <li>Ensayo de tracción (ASTM D638-14 y ASTM E8 / E8M-16a)</li>
                <li>Tracción (resistencia, ductilidad) (ASTM A370-18)</li>
            </ul>
            <br>
            <h3>Este laboratorio puede realizar:</h3>
            <div class="row-table-2">
              <div class="col-sm-12 col-md-6  container-border">
                <h4> <span class="circle"></span>Transferencia Tecnológica</h4>      
                <p>Asistencia técnica, atención a las necesidades tecnológicas y de innovación del sector productivo, acceso a transferencia de conocimiento, estudios y análisis técnicos de productos o procesos, demostraciones prácticas de maquinaria y equipos y plantas experimentales y análisis de falla en componentes mecánicos.</p>
                <br>
                <h4><span class="circle"></span>Capacitación en temas de procesos, manejo de normas y uso efectivo de las tecnologías</h4>      
                <p>Análisis de falla en componentes mecánicos, ensayos no destructivos, evaluación de integridad de componentes soldados, calificación de procedimientos de soldadura, metalurgia de la soldadura, cálculo y diseño de uniones soldadas, soldabilidad de materiales, inspección de recipientes a presión y capacitaciones en temas de calidad y control de productos.</p>   
              </div>
              <div class="col-sm-12 col-md-6  container-border">
                <h4><span class="circle"></span>Formulación, ejecución y gestión de investigación, desarrollo e innovación</h4>      
                <p>Investigación y adaptación de nuevos planteamientos y soluciones tecnológicas, diseño de prototipos de materiales, así como su validación, ensayos y análisis de laboratorio y certificaciones.</p>  
                <br>
                <h4><span class="circle"></span>Actividades de articulación </h4>      
                <p>Participación en mesas de elaboración de normas técnicas, comunicación con centros análogos del país o del exterior, para el intercambio de experiencias y conocimientos, gestión de proyectos, articulando los diferentes actores públicos o privados de cualquier índole en beneficio de la cadena productiva a la que pertenecen.</p>   
              </div>   
            </div>             
        </div>
    </div>  

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios del laboratorio <a href="contacto.php">aquí</a></p>
                    <br/>
                     <div id="lista-contacto-dt-lab">
                       <dl class="titulo"><dt>Contacto</dt><dd></dd></dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/05.png" alt="" /></dt>
                        <dd>
                            <strong>Mg. Anibal Rozas Gallegos</strong><br>
                            Jefe del Laboratorio<br>
                            Departamento de Ingeniería - Sección de Ingeniería Mecánica
                        </dd>
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/02.png" alt="" /></dt>
                        <dd> (01) 626-2000 anexo 4842 | 4879
                        </dd>
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/03.png" alt="" /></dt>
                        <dd><a href="mailto:labmat@pucp.edu.pe">labmat@pucp.edu.pe</a></dd>                  
                      </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                <!-- Wrapper for slides -->
                <div class="carousel-inner" role="listbox">
                    <div class="item active">
                        <a href="#modal_1" class="openform"><img src="img/materiales/01.jpg" alt="innovapucp laboratorio materiales 01" /></a>
                        <div id="modal_1" class="form">
                            <img class="center-block img-responsive" src="img/materiales/01.jpg" alt="innovapucp laboratorio materiales 01" />
                            <p>Detalle interior del microscopio electrónico <br>Quanta 650 FEI, con detecto (EDS) EDAX Team Holanda</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Detalle interior del microscopio electrónico<br> Quanta 650 FEI, con detecto (EDS) EDAX Team Holanda</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_2" class="openform"><img src="img/materiales/02.jpg" alt="innovapucp laboratorio materiales 02" /></a>
                        <div id="modal_2" class="form">
                            <img src="img/materiales/02.jpg" alt="innovapucp laboratorio materiales 02" class="center-block img-responsive"/>
                            <p>Ensayo en pieza metálica. Máquina de Dureza Rockwell Wilson 2002T USA</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Ensayo en pieza metálica. Máquina de Dureza Rockwell Wilson 2002T USA</p>
                        </div>
                    </div>

                    <div class="item">

                        <a href="#modal_3" class="openform"><img src="img/materiales/03.jpg" alt="innovapucp laboratorio materiales 03." /></a>
                        <div id="modal_3" class="form">
                            <img class="center-block img-responsive" src="img/materiales/03.jpg" alt="innovapucp laboratorio materiales 03." />
                            <p>Máquina de dureza ZwickRoell ZHU3000top, Brinell y Rockwell Alemania</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Máquina de dureza ZwickRoell ZHU3000top, Brinell y Rockwell Alemania</p>
                        </div>

                    </div>

                    <div class="item">

                         <a href="#modal_4" class="openform"> <img src="img/materiales/04.jpg" alt="innovapucp laboratorio materiales 04" /></a>
                        <div id="modal_4" class="form">
                             <img class="center-block img-responsive"  src="img/materiales/04.jpg" alt="innovapucp laboratorio materiales 04" />
                            <p>Máquina de Tracción Universal ZwickRoell Z050 Alemania</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Máquina de Tracción Universal ZwickRoell Z050 Alemania</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_5" class="openform"> <img src="img/materiales/05.jpg" alt="innovapucp laboratorio materiales soldadura 01" /></a>
                        <div id="modal_5" class="form">
                             <img class="center-block img-responsive" src="img/materiales/05.jpg" alt="innovapucp laboratorio materiales soldadura 01" />
                            <p>áquina Universal de Impacto ZwickRoell RKP450 (450J) Alemania</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>áquina Universal de Impacto ZwickRoell RKP450 (450J) Alemania</p>
                        </div>
                    </div>
                    <div class="item">

                        <a href="#modal_6" class="openform"><img src="img/materiales/06.jpg" alt="innovapucp laboratorio materiales torno horizontal 1" /></a>
                        <div id="modal_6" class="form">
                            <img class="center-block img-responsive" src="img/materiales/06.jpg" alt="innovapucp laboratorio materiales torno horizontal 1" />
                            <p>Microscopio metalográfico invertido DMI 5000M Leica Microsystems Alemania</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Microscopio metalográfico invertido DMI 5000M Leica Microsystems Alemania</p>
                        </div>
                    </div>
                     <div class="item">
                         <a href="#modal_7" class="openform"><img src="img/materiales/07.jpg" alt="innovapucp laboratorio materiales torno horizontal 1" /></a>
                        <div id="modal_7" class="form">
                            <img class="center-block img-responsive" src="img/materiales/07.jpg" alt="innovapucp laboratorio materiales torno horizontal 1" />
                            <p>Realizando ensayo con el Omniscan MX2</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Realizando ensayo con el Omniscan MX2</p>
                        </div>
                    </div>
                     <div class="item">

                         <a href="#modal_8" class="openform"> <img src="img/materiales/08.jpg" alt="innovapucp laboratorio materiales torno horizontal 1" /></a>
                        <div id="modal_8" class="form">
                             <img class="center-block img-responsive" src="img/materiales/08.jpg" alt="innovapucp laboratorio materiales torno horizontal 1" />
                            <p>Realizando ensayo en la máquina de Tracción Universal ZwickRoell Z050 Alemania</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Realizando ensayo en la máquina de Tracción Universal ZwickRoell Z050 Alemania</p>
                        </div>
                    </div>
                     
                </div>

                <ol class="carousel-indicators">
                  <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="4"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="5"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="6"></li>
                  <li data-target="#carousel-laboratorio-children" data-slide-to="7"></li>
      
                </ol>
                <!-- Left and right controls -->
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">
                    <!--<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                    <span class="sr-only">Previous</span>-->
                    <img src="img/left.png" alt="">
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">
                    <!--<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                    <span class="sr-only">Next</span>-->
                    <img src="img/right.png" alt="">
                </a>
            </div>
        </div>
    </div> 

    <?php include 'include/otros_laboratorios.php';?>   
    <?php include 'include/footer.php';?>
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
    <!-- Add mousewheel plugin (this is optional) -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>

    <script>
        $(document).ready(function(){
          $('.fancybox').fancybox();
          $(".openform").fancybox();
        });
      </script>
</body>
</html>
