<?php 
    include 'include/head.php';

?>
    <title>INNOVAPUCP | Laboratorio de Ingeniería de Minas</title> 
    <!-- Basic HTML Meta Tags -->
    <meta name='title' content='INNOVAPUCP | Laboratorio de Ingeniería de Minas' />  
    <meta name='description' content='El Laboratorio de Ingeniería de Minas brinda servicios de mineralogía y petrografía aplicados a la exploración de yacimientos minerales, al control de procesos de plantas concentradoras y a la ejecución de obras civiles, cimentaciones y obras hidráulicas.' />
    <meta name='url' content='<?php echo $host; ?>laboratorio-de-ingenieria-de-minas.php' />
    <meta name='keywords' content='INNOVAPUCP,Laboratorio de Ingeniería de Minas,servicios de mineralogía y petrografía,control de procesos,plantas concentradoras' />  
    <!-- OpenGraph Meta Tags --> 
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio de Ingeniería de Minas' />
    <meta property='og:description' content='El Laboratorio de Ingeniería de Minas brinda servicios de mineralogía y petrografía aplicados a la exploración de yacimientos minerales, al control de procesos de plantas concentradoras y a la ejecución de obras civiles, cimentaciones y obras hidráulicas.' />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-ingenieria-de-minas.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio"/>
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorios de la Sección de Ingeniería de Minas</div>
        </div>
    </div>
    
    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12  titulo-xs">
                    <h1 class="visible-xs-block">Laboratorios de la Sección de Ingeniería de Minas</h1>
                </div>
            </div>
            <div class="row">
                <div class=" col-sm-12 text-center">                  
                    <h3>La Sección de Ingeniería de Minas se especializa en mineralogía y petrografía aplicados a la exploración de yacimientos minerales, al control de procesos de plantas concentradoras y a la ejecución de obras civiles, cimentaciones y obras hidráulicas. El laboratorio está conformado por docentes especialistas que se dedican a la investigación y formación de profesionales en las áreas de trabajo de Geología, Metalurgia Extractiva, Minería y Medio Ambiente.</h3>
                </div>               
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <h3>Los laboratorios de Ingeniería de Minas pueden realizar:</h3>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6 container-border">
                    <ul>
                        <li>Análisis de oro y plata, determinación de humedad, determinación de material volátil, análisis inmediato de  carbón, análisis de suelos y determinación de sales totales solubles.</li>
                        <li>Prueba de drenaje ácido de rocas y simulación de ensayos de biolixiviación.</li>
                        <li>Análisis Químico de Minerales.</li>
                        <li>Pruebas de secado, tostación y calcinación.</li>
                        <li>Ensayos en electrometalurgia y pruebas de electrodeposición.</li>
                    </ul> 
                </div>
                <div class="col-sm-12 col-md-6 container-border">                               
                    <ul>
                        <li>Lixiviación en botellas y columna, pruebas de procesos de extracción por solventes, mediciones de conductividad, pH y oxígeno en solución.</li>
                        <li>Calibración de anemómetros y determinación de los coeficientes de pérdida de las diferentes mangas de ventilación.</li>
                        <li>Estudios geotécnicos, petrográficos y mineralógicos de muestras con objetivos de exploración y desarrollo minero.</li>
                        <li>Carga puntual, propiedades físicas y elásticas, tracción indirecta, compresión simple y  triaxial, corte directo y Salek Durability.</li>                          
                    </ul>   
                </div>
            </div>            
        </div>
    </div>

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios de la sección <a href="contacto.php">aquí</a></p>
                    <br/>
                    <div id="lista-contacto-dt-lab">
                      <dl class="titulo"><dt>Contacto</dt><dd></dd></dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/05.png" alt="" /></dt>
                        <dd>
                            <strong>Dra. Maribel Guzmán Córdova</strong><br>
                            Coordinadora de la Sección<br>
                            Departamento de Ingeniería - Sección de Ingeniería de Minas
                        </dd>
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/02.png" alt="" /></dt>
                        <dd> (01) 626-2000 anexo 5000
                        </dd>                  
                      </dl>
                      <dl  class="dl-horizontal">
                        <dt><img src="img/03.png" alt="" /></dt>
                        <dd><a href="mailto:mfcapurr@pucp.edu.pe">mfcapurr@pucp.edu.pe</a></dd>                  
                      </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                     <!-- Indicators -->
                <div class="carousel-inner" role="listbox">
                    <div class="item active">
                        <a href="#modal_1" class="openform"><img src="img/minas/01.jpg" alt="innovapucp laboratorio minas 01" /></a>
                        <div id="modal_1" class="form">
                            <img class="img-responsive" src="img/minas/01.jpg" alt="innovapucp laboratorio minas 01" />
                            <p>Laboratorio de Ingeniería de Minas</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Ingeniería de Minas</p>
                        </div>
                    </div>

                    <div class="item">                    
                        <a href="#modal_2" class="openform"><img src="img/minas/02.jpg" alt="innovapucp laboratorio minas 02" /></a>
                        <div id="modal_2" class="form">
                            <img class="img-responsive" src="img/minas/02.jpg" alt="innovapucp laboratorio minas 02" />
                            <p>Laboratorio de Ingeniería de Minas</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Ingeniería de Minas</p>
                        </div>
                    </div>

                    <div class="item">

                        <a href="#modal_3" class="openform"><img src="img/minas/03.jpg" alt="innovapucp laboratorio minas 03" /></a>
                        <div id="modal_3" class="form">
                            <img class="img-responsive" src="img/minas/03.jpg" alt="innovapucp laboratorio minas 03" />
                            <p>Laboratorio de Mecánica de Rocas Prensa para compresiones</p>
                        </div>

                         <div class="carousel-caption">    
                            <p>Laboratorio de Mecánica de Rocas Prensa para compresiones </p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_4" class="openform"><img src="img/minas/04.jpg" alt="innovapucp laboratorio minas 04" /></a>
                        <div id="modal_4" class="form">
                            <img class="img-responsive" src="img/minas/04.jpg" alt="innovapucp laboratorio minas 03" />
                            <p>Laboratorio de Mecánica de Rocas Prensa universal</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Mecánica de Rocas Prensa universal </p>
                        </div>

                    </div>

                    <div class="item">

                        <a href="#modal_5" class="openform"><img src="img/minas/05.jpg" alt="innovapucp laboratorio minas 05" /></a>
                        <div id="modal_5" class="form">
                            <img class="img-responsive" src="img/minas/05.jpg" alt="innovapucp laboratorio minas 05" />
                            <p>Laboratorio de Microscopía Estudios de roca</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Microscopía Estudios de roca</p>
                        </div>
                          
                    </div>

                    <div class="item">

                        <a href="#modal_6" class="openform"><img src="img/minas/06.jpg" alt="innovapucp laboratorio minas 06" /></a>
                        <div id="modal_6" class="form">
                            <img class="img-responsive" src="img/minas/06.jpg" alt="innovapucp laboratorio minas 06" />
                            <p>Laboratorio de Microscopía Microscopio Polarizante para estudios de roca</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Microscopía Microscopio Polarizante para estudios de roca</p>
                        </div>

                    </div>

                     <div class="item">
                        <a href="#modal_7" class="openform"><img src="img/minas/07.jpg" alt="innovapucp laboratorio minas 07" /></a>
                        <div id="modal_7" class="form">
                            <img class="img-responsive" src="img/minas/07.jpg" alt="innovapucp laboratorio minas 07" />
                            <p>Laboratorio de Mineralurgía Planta de concentración de minerales</p>
                        </div>

                        <div class="carousel-caption">    
                            <p>Laboratorio de Mineralurgía Planta de concentración de minerales</p>
                        </div>

                    </div>

                     <div class="item">

                        <a href="#modal_8" class="openform"><img src="img/minas/08.jpg" alt="innovapucp laboratorio minas 08" /></a>
                        <div id="modal_8" class="form">
                            <img class="img-responsive" src="img/minas/08.jpg" alt="innovapucp laboratorio minas 08" />
                            <p>Laboratorio de Pirometalurgía Agitador Orbital</p>
                        </div>

                         <div class="carousel-caption">    
                            <p>Laboratorio de Pirometalurgía Agitador Orbital</p>
                        </div>


                    </div>

                     <div class="item">
                        <a href="#modal_9" class="openform"><img src="img/minas/09.jpg" alt="innovapucp laboratorio minas 09" /></a>
                        <div id="modal_9" class="form">
                            <img class="img-responsive" src="img/minas/09.jpg" alt="innovapucp laboratorio minas 09" />
                            <p>Laboratorio de Pirometalurgía Espectrómetro de absorción atómica</p>
                        </div>

                         <div class="carousel-caption">    
                            <p>Laboratorio de Pirometalurgía Espectrómetro de absorción atómica</p>
                        </div>
                    </div>

                    <div class="item">
                        
                        <a href="#modal_10" class="openform"><img src="img/minas/10.jpg" alt="innovapucp laboratorio minas 10" /></a>
                        <div id="modal_10" class="form">
                            <img class="img-responsive" src="img/minas/10.jpg" alt="innovapucp laboratorio minas 10" />
                            <p>Laboratorio de Pirometalurgía Mufla</p>
                        </div>

                         <div class="carousel-caption">    
                            <p>Laboratorio de Pirometalurgía Mufla</p>
                        </div>
                    </div>

                </div>

                <ol class="carousel-indicators">
                      <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="4"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="5"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="6"></li>
                      <li data-target="#carousel-laboratorio-children" data-slide-to="7"></li>   
                      <li data-target="#carousel-laboratorio-children" data-slide-to="8"></li>   
                      <li data-target="#carousel-laboratorio-children" data-slide-to="9"></li>   

                </ol>
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">
                    <img src="img/left.png" alt="flecha-izquierda" />
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">
                    <img src="img/right.png" alt="flecha-derecha" />
                </a>
            </div>
        </div> 
    </div>

    <?php include 'include/otros_laboratorios.php';?>      
    <?php include 'include/footer.php';?>
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
      <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
      <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
      <!-- Add mousewheel plugin (this is optional) -->
      <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>
      <script>
        $(document).ready(function(){
          $('.fancybox').fancybox();
          $(".openform").fancybox();
        });
      </script>  
</body>
</html>
