<?php 
    include 'include/head.php';

?>
    <title>INNOVAPUCP | Laboratorios de Electricidad y Electrónica</title>
    <!-- Basic HTML Meta Tags -->
    <meta name='title' content='INNOVAPUCP | Laboratorio de Electricidad y Electrónica' />
    <meta name='description' content='La Sección de Electricidad y Electrónica cuenta con amplia experiencia dentro de los campos de docencia, investigación y desarrollo tecnológico a través de servicios especializados en electrónica.' />
    <meta name='url' content='<?php echo $host; ?>laboratorio-de-electricidad-y-electronica.php' />
    <meta name='keywords' content='INNOVAPUCP,Laboratorio de Electricidad y Electrónica, investigación y desarrollo tecnológico, especializados en electrónica,desarrollo tecnológico,servicios especializados' />
    <!-- OpenGraph Meta Tags -->
    <meta property="og:locale" content="es_ES" />
    <meta property="og:type" content="website" />
    <meta property='og:title' content='INNOVAPUCP | Laboratorio de Electricidad y Electrónica' />
    <meta property='og:description' content='La Sección de Electricidad y Electrónica cuenta con amplia experiencia dentro de los campos de docencia, investigación y desarrollo tecnológico a través de servicios especializados en electrónica.' />
    <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-electricidad-y-electronica.php' />
    <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio" />
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorios de la Sección de Electricidad y Electrónica</div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 titulo-xs">
                    <h1 class="visible-xs-block">Laboratorios de la Sección de Electricidad y Electrónica</h1>
                </div>
            </div>
            <div class="row">
                <div class=" col-sm-12 text-center">
                    <h3>El laboratorio de Electricidad y Electrónica cuenta con una amplia experiencia dentro de los campos de docencia, investigación y desarrollo tecnológico a través de servicios especializados en electrónica. El laboratorio está conformado por docentes especialistas en las áreas de Circuitos y Sistemas Electrónicos, Robótica, Control y Automatización, Electricidad y Bioingeniería.</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <h3>Los laboratorios de la sección pueden realizar:</h3>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <ul>
                        <li>Analizadores y simuladores para la verificación de equipos biomédicos. </li>
                        <li>Sistema de adquisición de datos para fisiología experimental, osciloscopios digitales y computadoras. </li>
                        <li>Investigación, desarrollo, aplicación, análisis, evaluación de impacto y difusión de tecnologías biomédicas. </li>
                        <li>Mediciones de las variables eléctricas en circuitos y en sistemas electrónicos de pequeña y mediana potencia. </li>
                        <li>Desarrollo de aplicaciones tecnológicas: sistemas digitales en lógica programable, como los FPGAs y diseño de circuitos integrados de aplicación específica (ASICs). </li>
                    </ul>
                </div>
                <div class="col-sm-12 col-md-6 container-border">
                    <ul>
                        <li>Informática médica, reconstrucción 3D de imágenes, certificación de ecógrafos, pruebas de índices mecánicos y desarrollo de software para imágenes médicas. </li>
                        <li>Diseño de placas impresas y modelado en 3D. </li>
                        <li>Desarrollo de trabajos de investigación relacionados con el procesamiento de señales e imágenes digitales. </li>
                        <li>Servicios relacionados a materiales, instalaciones y uso racional de la energía eléctrica. </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios de la sección <a href="contacto.php">aquí</a></p>
                    <br>
                    <div id="lista-contacto-dt-lab">
                        <dl class="titulo"><dt>Contacto</dt>
                            <dd></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/05.png" alt="" /></dt>
                            <dd>
                                <strong>Lic. Kathia Paredes</strong><br>
                                Departamento de Ingeniería - Sección de Electricidad y Electrónica
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/02.png" alt="" /></dt>
                            <dd>(01) 626-2000 anexo 4671
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/03.png" alt="" /></dt>
                            <dd> <a href="mailto:kparedesm@pucp.edu.pe">kparedesm@pucp.edu.pe</a></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                <div class="carousel-inner" role="listbox">
                    <div class="item active">
                        <a href="#modal_1" class="openform"><img src="img/electricidad/01.jpg" alt="innovapucp laboratorio electricidad 01" /></a>
                        <div id="modal_1" class="form">
                            <img class="img-responsive" src="img/electricidad/01.jpg" alt="innovapucp laboratorio electricidad 01" />
                            <p>Laboratorio de Bioingeniería Biopac</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Laboratorio de Bioingeniería Biopac</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_2" class="openform"><img src="img/electricidad/02.jpg" alt="innovapucp laboratorio electricidad 02" /></a>
                        <div id="modal_2" class="form">
                            <img class="img-responsive" src="img/electricidad/02.jpg" alt="innovapucp laboratorio electricidad 02" />
                            <p>Laboratorio de Bioingeniería Regenerador de tejidos</p>
                        </div>
                        <div class="carousel-caption">
                            <p>Laboratorio de Bioingeniería Regenerador de tejidos</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_3" class="openform"><img src="img/electricidad/03.jpg" alt="innovapucp laboratorio electricidad 03" /></a>
                        <div id="modal_3" class="form">
                            <img class="img-responsive" src="img/electricidad/03.jpg" alt="innovapucp laboratorio electricidad 03" />
                            <p>Laboratorio de Control Avanzado PXI</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Laboratorio de Control Avanzado PXI</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_4" class="openform"><img src="img/electricidad/04.jpg" alt="innovapucp laboratorio electricidad 04" /></a>
                        <div id="modal_4" class="form">
                            <img class="img-responsive" src="img/electricidad/04.jpg" alt="innovapucp laboratorio electricidad 04" />
                            <p>Laboratorio de Proyectos Electrónico Osciloscopio</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Laboratorio de Proyectos Electrónico Osciloscopio</p>
                        </div>
                    </div>

                    <div class="item">
                        <a href="#modal_5" class="openform"><img src="img/electricidad/05.jpg" alt="innovapucp laboratorio electricidad 05" /></a>
                        <div id="modal_5" class="form">
                            <img class="img-responsive" src="img/electricidad/05.jpg" alt="innovapucp laboratorio electricidad 05" />
                            <p>Planta de control de temperatura</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Planta de control de temperatura</p>
                        </div>
                    </div>
                </div>

                <ol class="carousel-indicators">
                    <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="4"></li>
                </ol>
                <!-- Left and right controls -->
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">
                        <img src="img/left.png" alt="">
                    </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">
                        <img src="img/right.png" alt="" />
                    </a>
            </div>
        </div>
    </div>

    <?php include 'include/otros_laboratorios.php';?>
    <?php include 'include/footer.php';?>
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
    <!-- Add mousewheel plugin (this is optional) -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>

    <script>
        $(document).ready(function() {
            $('.fancybox').fancybox();
            $(".openform").fancybox();
        });
    </script>
</body>

</html>
