<?php 
  include 'include/head.php';
  include("admin/config.php");
?>
  <title>INNOVAPUCP | Centro de Caracterización de Materiales</title>
  <meta name='title' content='INNOVAPUCP | Centro de Caracterización de Materiales' />
  <meta name='description' content='El Centro de Caracterización de Materiales (CAM-PUCP) constituye un espacio que aloja equipos de envergadura para brindar soporte en el desarrollo de investigaciones y servicios en el campo de la evaluación de materiales en escala micro y nano-métrica.'
  />
  <meta name='url' content='<?php echo $host; ?>laboratorio-de-centro-de-caracterizacion-de-materiales.php' />
  <meta name='keywords' content='INNOVAPUCP,Centro de Caracterización de Materiales, investigaciones y servicios,micro y nano-métrica,CAM-PUCP' />
  <!-- OpenGraph Meta Tags -->
  <meta property="og:locale" content="es_ES" />
  <meta property="og:type" content="website" />
  <meta property='og:title' content='INNOVAPUCP | Centro de Caracterización de Materiales' />
  <meta property='og:description' content='El Centro de Caracterización de Materiales (CAM-PUCP) constituye un espacio que aloja equipos de envergadura para brindar soporte en el desarrollo de investigaciones y servicios en el campo de la evaluación de materiales en escala micro y nano-métrica.'
  />
  <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-centro-de-caracterizacion-de-materiales.php' />
  <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio" />
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorio del Centro de Caracterización de Materiales</div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 separador-top titulo-xs">
                    <h1 class="visible-xs-block">Centro de Caracterización de Materiales</h1>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <h3 class="text-center">El Centro de Caracterización de Materiales (CAM-PUCP) constituye un espacio dirigido por docentes especialistas para brindar soporte en el desarrollo de investigaciones y servicios en el campo de la evaluación de materiales en escala micro y nano-métrica.</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <p>El CAM realiza investigaciones de diversas disciplinas tales como ciencia de materiales, física, química, arqueología, ingeniería, medicina, odontología, entre otras; y, por personal de diversas industrias tales como la minero-metalúrgico, hidrocarburos, alimentaria, farmacéutica, metal-mecánica, electrónica y manufacturera.</p>
            <br/>
            
            <h3>Este Centro puede realizar:</h3>

            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <h4><strong>Microscopía Electrónica de Barrido,</strong> aplicable en: </h4>
                    <ul>
                        <li> Estudios morfológicos y de composición de minerales. </li>
                        <li> Estudio estadístico (determinación de forma y distribución de tamaño de partículas).</li>
                        <li> Análisis topográfico y evaluación de superficies de fractura.</li>
                        <li> Análisis de fases y microestructura en materiales metálicos y no metálicos.</li>
                        <li> Análisis de recubrimientos e interfases.</li>
                        <li> Análisis de materiales arqueológicos.</li>
                        <li> Investigaciones forenses.</li>
                    </ul>
                </div>
                <div class="border-bottom col-sm-12 col-md-6 container-border">
                    <h4><strong>Difracción de Rayos X</strong>, aplicable en: </h4>
                    <ul>
                        <li>Identificación y cuantificación de minerales.</li>
                        <li>Análisis de arcillas.</li>
                        <li>Determinación de estructura atómica y fases en aleaciones.</li>
                        <li>Reflectometría de Rayos X</li>
                        <li>Análisis de cristalinidad en polímeros.</li>
                        <li>Análisis de películas delgadas.</li>
                        <li>Determinación de parámetros de red.</li>
                    </ul>
                </div>
            </div>
            <br>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <h4><strong>Fluorescencia de Rayos X,</strong> aplicable en: </h4>
                    <ul>
                        <li>Análisis de composición elemental de materiales sólidos</li>
                        <li>Monitoreo geológico</li>
                        <li>Análisis de rocas y sedimentos</li>
                        <li>Análisis de composición en biofarmacéutica</li>
                        <li>Análisis de pureza y composición de materiales poliméricos</li>
                        <li>Ensayos de materiales para filtros</li>
                        <li>Análisis de muestras en polvo</li>
                        <li>Análisis de materiales arqueológicos</li>
                    </ul>
                </div>
                <div class="col-sm-12 col-md-6 container-border">
                    <h4><strong>Espectroscopia Raman,</strong> aplicable en:</h4>
                    <ul>
                        <li>Caracterización estructural y química de materiales.</li>
                        <li>Análisis de pigmentos.</li>
                        <li>Identificación de minerales.</li>
                        <li>Análisis de compuestos farmacéuticos.</li>
                        <li>Análisis de alotropías del carbono (nanotubos, grafeno, grafito, diamante, etc.).</li>
                        <li>Análisis de materiales opto-electrónicos.</li>
                        <li>Caracterización de nano y biomateriales .</li>
                        <li>Análisis forenses.</li>
                    </ul>
                </div>
            </div>
            <br>
            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <h4><strong>Espectrofotometría UV-VIS-NIR,</strong> aplicable en: </h4>
                    <ul>
                        <li>Evaluación de capas delgadas.</li>
                        <li>Análisis de vidrios de tecnología avanzada.</li>
                        <li>Recubrimientos reflectivos y antireflectivos.</li>
                        <li>Detección de impurezas.</li>
                        <li>Análisis de composición de soluciones líquidas.</li>
                    </ul>
                </div>
                <div class="col-sm-12 col-md-6 container-border">
                    <h4><strong>Análisis de Quimisorción y Fisisorción,</strong> aplicable en:</h4>
                    <ul>
                        <li>Estudios de propiedades catalíticas de materiales.</li>
                        <li>Análisis de materiales para filtros.</li>
                        <li>Análisis de carbones activados, minerales, arcillas y zeolitas.</li>
                        <li>Estudios de capacidad de adsorción y desorción a temperatura controlada.</li>
                        <li>Análisis de reacciones de oxidación y reducción a temperatura controlada.</li>
                        <li>Análisis de materiales arqueológicos.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca del centro <a href="contacto.php">aquí</a></p>
                    <br/>
                    <div id="lista-contacto-dt-lab">
                        <dl class="titulo"><dt>Contacto</dt>
                            <dd></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/05.png" alt="" /></dt>
                            <dd>
                                <strong>Dr. Francisco Rumiche</strong><br>
                                Jefe del CAM
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/02.png" alt="" /></dt>
                            <dd> (01) 626-2000 anexo 7740 | 7741
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/03.png" alt="" /></dt>
                            <dd><a href="mailto:cam@pucp.edu.pe">cam@pucp.edu.pe</a></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <br>

    <div class="carousel-laboratorio-children">
        <div class="container">
            <iframe width='100%' height='600' src='https://roundme.com/embed/aW2p2vQIyBCMx0PqfLOc' frameborder='0' webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
        </div>
    </div>

    <?php include 'include/otros_laboratorios.php';?>
    <?php include 'include/footer.php';?>
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
    <!-- Add mousewheel plugin (this is optional) -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>

    <script>
        $(document).ready(function() {
            $('.fancybox').fancybox();
            $(".openform").fancybox();
        });
    </script>
</body>

</html>
