<?php 
  include 'include/head.php';

?>
  <title>INNOVAPUCP | Laboratorio de Acústica</title>
  <!-- Basic HTML Meta Tags -->
  <meta name='title' content='INNOVAPUCP | Laboratorio de Acústica' />
  <meta name='description' content='El Laboratorio de Acústica cuenta con más de 30 años de experiencia en el medio local desarrollando actividades que giran alrededor de las disciplinas de acústica arquitectónica, electro acústica, control de ruido y vibraciones y su relación con la dinámica estructural.'
  />
  <meta name='url' content='<?php echo $host; ?>laboratorio-de-acustica.php' />
  <meta name='keywords' content='INNOVAPUCP,laboratorio de Acústica, 30 años de experiencia,disciplinas de acústica arquitectónica' />
  <!-- OpenGraph Meta Tags -->
  <meta property="og:locale" content="es_ES" />
  <meta property="og:type" content="website" />
  <meta property='og:title' content='INNOVAPUCP | Laboratorio de Acústica' />
  <meta property='og:description' content='El Laboratorio de Acústica cuenta con más de 30 años de experiencia en el medio local desarrollando actividades que giran alrededor de las disciplinas de acústica arquitectónica, electro acústica, control de ruido y vibraciones y su relación con la dinámica estructural.'
  />
  <meta property='og:url' content='<?php echo $host; ?>laboratorio-de-acustica.php' />
  <meta property='og:image' content='<?php echo $host; ?>img/logo-redes-laboratorio.jpg' />
</head>

<body id="laboratorio-children">
    <!--[if lt IE 8]>
            <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <input type="hidden" value="3" id="txt_servicio" />
    <?php include 'include/menu.php';?>

    <div class="laboratorio-children-menu">
        <div class="texto-menu">
            <div class="container">Laboratorio de Acústica</div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="laboratorio-children-introduccion">
            <div class="row">
                <div class="col-xs-12 titulo-xs">
                    <h1 class="visible-xs-block">Laboratorio de Acústica</h1>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <h3 class="text-center">El Laboratorio de Acústica cuenta con más de 30 años de experiencia en el medio local desarrollando actividades en las disciplinas de acústica arquitectónica, electroacústica, control de ruido y vibraciones y su relación con la dinámica estructural. Asimismo, tiene como principales objetivos incentivar el interés de los estudiantes por estos temas, la investigación aplicada en acústica y vibraciones y el desarrollo de la acústica en el país.</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="caracteristicas-laboratorio">
            <p>El laboratorio posee la infraestructura de instrumentación más moderna del país y un staff de profesionales con distinguidas credenciales académicas y amplia experiencia, dada su alta exposición con la industria.</p>
            <br>
            
            <h3>Este laboratorio puede realizar:</h3>

            <div class="row-table-2">
                <div class="col-sm-12 col-md-6  container-border">
                    <ul>
                        <li>Medición de la línea base de niveles de ruido ambiental.</li>
                        <li>Medición y generación de mapas de ruido aeronáutico.</li>
                        <li>Evaluación acústica del sistema de publidifusión.</li>
                    </ul>
                </div>
                <div class="col-sm-12 col-md-6 container-border">
                    <ul>
                        <li>Diseño del equipamiento electro acústico.</li>
                        <li>Diseño de las losas flotantes y silenciadores de ductos de extracción de aire.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="container padding_section">
        <div class="informacion-servicio">
            <div class="row">
                <div class="col-sm-12">
                    <p>Recibe más información acerca de los servicios del laboratorio <a href="contacto.php">aquí</a></p>
                    <br/>
                    <div id="lista-contacto-dt-lab">
                        <dl class="titulo"><dt>Contacto</dt>
                            <dd></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/05.png" alt="" /></dt>
                            <dd>
                                <strong>Mg. Richard Rivera</strong><br>
                                Jefe del Laboratorio:<br>
                                Departamento de Ciencias - Sección Física
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/02.png" alt="" /></dt>
                            <dd>(01) 626-2000 anexo 4137 | 4110
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt><img src="img/03.png" alt="" /></dt>
                            <dd> <a href="mailto:rrivera@pucp.edu.pe">rrivera@pucp.edu.pe</a></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="carousel-laboratorio-children">
        <div class="container">
            <div id="carousel-laboratorio-children" class="carousel slide" data-ride="carousel">
                <div class="carousel-inner" role="listbox">
                    <div class="item active">
                        <a href="#modal_1" class="openform"><img src="img/acustica/01.jpg" alt="innovapucp laboratorio acustica 01" /></a>
                        <div id="modal_1" class="form">
                            <img class="img-responsive" src="img/acustica/01.jpg" alt="innovapucp laboratorio acustica 01" />
                            <p>Ensayo Modal Astillero de la Marina</p>
                        </div>
                        <div class="carousel-caption">
                            <p>Ensayo Modal Astillero de la Marina</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_2" class="openform"><img src="img/acustica/02.jpg" alt="innovapucp laboratorio acustica 02" /></a>
                        <div id="modal_2" class="form">
                            <img class="img-responsive" src="img/acustica/02.jpg" alt="innovapucp laboratorio acustica 02" />
                            <p>PUCP 1 SAT 1</p>
                        </div>
                        <div class="carousel-caption">
                            <p>PUCP 1 SAT 1</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_3" class="openform"><img src="img/acustica/03.jpg" alt="innovapucp laboratorio acustica 03" /></a>
                        <div id="modal_3" class="form">
                            <img class="img-responsive" src="img/acustica/03.jpg" alt="innovapucp laboratorio acustica 03" />
                            <p>Proyecto Aeropuerto 2007</p>
                        </div>
                        <div class="carousel-caption">
                            <p>Proyecto Aeropuerto 2007</p>
                        </div>
                    </div>
                    <div class="item">
                        <a href="#modal_4" class="openform"><img src="img/acustica/04.jpg" alt="innovapucp laboratorio acustica 04" /></a>
                        <div id="modal_4" class="form">
                            <img class="img-responsive" src="img/acustica/04.jpg" alt="innovapucp laboratorio acustica 04" />
                            <p>Mapas de ruido en el Aeropuerto</p>
                        </div>

                        <div class="carousel-caption">
                            <p>Mapas de ruido en el Aeropuerto</p>
                        </div>
                    </div>
                </div>
                <ol class="carousel-indicators">
                    <li data-target="#carousel-laboratorio-children" data-slide-to="0" class="active"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="1"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="2"></li>
                    <li data-target="#carousel-laboratorio-children" data-slide-to="3"></li>
                </ol>
                <a class="left carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="prev">
                    <img src="img/left.png" alt="">
                </a>
                <a class="right carousel-control" href="#carousel-laboratorio-children" role="button" data-slide="next">
                    <img src="img/right.png" alt="">
                </a>
            </div>
        </div>
    </div>
    <?php include 'include/otros_laboratorios.php';?>
    <?php include 'include/footer.php';?>
    <!-- FACEYBOX -->
    <!-- Add fancyBox main JS and CSS files -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/source/jquery.fancybox.js"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo $host; ?>fancybox/source/jquery.fancybox.css?v=2.1.5" media="screen" />
    <!-- Add mousewheel plugin (this is optional) -->
    <script type="text/javascript" src="<?php echo $host; ?>fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>
    <script>
        $(document).ready(function() {
            $('.fancybox').fancybox();
            $(".openform").fancybox();
        });
    </script>
</body>

</html>
