<?php
include('../config.php');

if (PHP_SAPI == 'cli')
die('Este ejemplo sólo se puede ejecutar desde un navegador Web');
 
/** Incluye PHPExcel */
require_once 'lib/Classes/PHPExcel.php';
// Crear nuevo objeto PHPExcel
$objPHPExcel = new PHPExcel();
 
// Propiedades del documento
$objPHPExcel->getProperties()->setCreator("INNOVAPUCP")
->setLastModifiedBy("INNOVAPUCP")
->setTitle("Office 2010 XLSX INNOVAPUCP")
->setSubject("Office 2010 XLSX INNOVAPUCP")
->setDescription("Documento de prueba para Office 2010 XLSX, generado usando clases de PHP.")
->setKeywords("office 2010 openxml php")
->setCategory("reporte_contacto_innovapucp - INNOVAPUCP");
 
 
 
// Combino las celdas desde A1 hasta E1
$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:J1');
 
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Reporte de Contacto - INNOVAPUCP')
            ->setCellValue('A2', 'Solución')
            ->setCellValue('B2', 'nombres_apellidos')
            ->setCellValue('C2', 'empresa')
            ->setCellValue('D2', 'cargo')
            ->setCellValue('E2', 'correo')
            ->setCellValue('F2', 'telefono')
            ->setCellValue('G2', 'como_se_entero_nosotros')
            ->setCellValue('H2', 'mensaje')
            ->setCellValue('I2', 'aceptacion')
            ->setCellValue('J2', 'fecha');

$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
 
$objPHPExcel->getActiveSheet()->getStyle('A1:J2')->applyFromArray($boldArray);
 
//Ancho de las columnas
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(60);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(10);
 
$sql="SELECT * FROM contacto  order by id";
$query=mysqli_query($con,$sql);
$cel=3;//Numero de fila donde empezara a crear  el 2018_seminario_internacional_udep_30_mayo
while ($row=mysqli_fetch_array($query)){
$solucion=$row['solucion'];
$nombres_apellidos=$row['nombres_apellidos'];
$empresa=$row['empresa'];
$cargo=$row['cargo'];
$correo=$row['correo'];
$telefono=$row['telefono'];
$como_se_entero_nosotros=$row['como_se_entero_nosotros'];
$mensaje=$row['mensaje'];
$aceptacion=$row['aceptacion'];
$fecha=$row['fecha'];
$a="A".$cel;
$b="B".$cel;
$c="C".$cel;
$d="D".$cel;
$e="E".$cel;
$f="F".$cel;
$g="G".$cel;
$h="H".$cel;
$i="I".$cel;
$j="J".$cel;


// Agregar datos
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue($a, $solucion)
            ->setCellValue($b, $nombres_apellidos)
            ->setCellValue($c, $empresa)
            ->setCellValue($d, $cargo)
            ->setCellValue($e, $correo)
            ->setCellValue($f, $telefono)
            ->setCellValue($g, $como_se_entero_nosotros)
            ->setCellValue($h, $mensaje)
            ->setCellValue($i, $aceptacion)
            ->setCellValue($j, $fecha);
            /*->setCellValue($c, $cargo)
            ->setCellValue($d, $colegio)
            ->setCellValue($e, $fecha_registro);*/
$cel+=1;
}
 
/*Fin extracion de datos MYSQL*/
$rango="A2:$j" ;
$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
);
$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);
// Cambiar el nombre de hoja de cálculo
$objPHPExcel->getActiveSheet()->setTitle('Reporte de Contacto');
 
 
// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
$objPHPExcel->setActiveSheetIndex(0);
 
 
// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="reporte_contacto_innovapucp.xls"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');
 
// Si usted está sirviendo a IE a través de SSL , a continuación, puede ser necesaria la siguiente
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0
 
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
exit;