jQuery(document).ready(function($){
    var $submitBtn = $('#submitBtn'),
    $imagen_cabecera = $('#imagen_cabecera'),
    $imagen_redes = $('#imagen_redes'),
    $imgContainer_cabe = $('#imgContainer_cabe'),
    $imgContainer_redes = $('#imgContainer_redes'),
    $titulo = $('#titulo');
                
      $('#formulario_noticiaseditar').validate({
        rules: {
            cuerpo_interno:{
                cke_required:true,
                minlength: 10
            },
            keywords:{                          
                required: true
            },
            titulo:{                            
              required: true,
              minlength: 10
            },
            bajada:{                            
              required: true,
              minlength: 10
            },
            categoria: {                            
              required: true
            },
            imagen_interna: {                           
                required: false,
                extension: "jpg,jpeg,png",
                filesize:{
                  size:120000,
                  kb:120,
                }
            },
            imagen_cabecera: {                          
                required: false,
                extension: "jpg,jpeg,png",
                callbackTest: {
                    callback: function() {
                         return $imagen_cabecera.data('imageWidth')  == 1170 && $imagen_cabecera.data('imageHeight')  == 450;
                    }
                 },
                 filesize:{
                  size:120000,
                  kb:120,
                }
            },
            imagen_redes: {                         
                required: false,
                extension: "jpg,jpeg,png",
                callbackRedes: {
                    callback_3: function() {
                    return $imagen_redes.data('imageWidth')  >= 200 && $imagen_redes.data('imageHeight')  >= 200;
                    }                            
                 },
                 filesize:{
                  size:120000,
                  kb:120,
                }                      
            }
        },
            errorPlacement: function( error, element ) {
                if (element.attr("name") == "categoria"){
                    error.insertBefore( element.parent().parent().parent());
                }else{
                    error.insertBefore(element);
                }
        },
         messages: {
            imagen_cabecera: {
              required: "You must insert an image",
              callbackTest: "La imágen de cabecera debe tener un tamaño mínimo de 1170px y 450px.",
            },
            imagen_redes: {
              required: "You must insert an image",
              callbackRedes: "La imágen de cabecera debe tener un tamaño mínimo de 200px y 200px."
            }
        },
        submitHandler: function (form){
          var nombre_form=form.name;
          if(nombre_form != ""){
            grabarnuevanoticia(nombre_form);
          }else{
            alert("Lo sentimos, grabe nuevamente");
          }      
        },
        invalidHandler: function (form) {
        }            
    });

     function grabarnuevanoticia(nombre_form){
       $("#cargando").css("display", "inline");
      var pagina;
      if(nombre_form == "formulario_noticiasnuevo"){
        pagina='noticianue_grabar.php'
      }else if(nombre_form == "formulario_noticiaseditar"){
        pagina='noticiaedi_grabar.php'
      }else{
        alert("Lo sentimos, intente grabar nuevamente");
      }

      var d=$("#cuerpo_interno").val();
      var fd = new FormData($('#'+nombre_form)[0]);
     $.ajax({
       url: pagina,
       data: fd,
      contentType: false,
       processData: false,
       type: 'POST',
       success: function(data){
        if(data==1){
          $("#cargando").css("display", "none");
          $('#alertBoxes').html('<div class="box-success alert alert-success"></div>');
          $('.box-success').show().html('Grabando...'); 
          window.location.href="noticias.php";
        }else if(data==3){
           $("#cargando").css("display", "none");
          $('#alertBoxes').html('<div class="box-error alert alert-warning"></div>');
          $('.box-error').show().html('Lo sentimos, el título para la noticia ya existe');
        }else if(data==2){
           $("#cargando").css("display", "none"); 
          $('#alertBoxes').html('<div class="box-error alert alert-warning"></div>');
          $('.box-error').show().html('Lo sentimos, intente grabar nuevamente');
        }else if(data==4){
           $("#cargando").css("display", "none");
          $('#alertBoxes').html('<div class="box-error alert alert-warning"></div>');
          $('.box-error').show().html('Lo sentimos, intente subir las imágenes nuevamente');
        }else if(data==5){
          $('#alertBoxes').html('<div class="box-error alert alert-warning"></div>');
          $('.box-error').show().html('Lo sentimos, los datos estan íncompletos o son incorrectos');
        }else if(data==6){
          $('#alertBoxes').html('<div class="box-error alert alert-warning"></div>');
          $('.box-error').show().html('Por favor ingrese el título para la noticia');
        }else{
           $("#cargando").css("display", "none");
          $('#alertBoxes').html('<div class="box-error alert alert-warning"></div>');
          $('.box-error').show().html('Por favor comuníquese con el administrador');
        }
       }
       });
     }


    $('#formulario_noticiasnuevo').validate({
        rules: {
          cuerpo_interno:{
              cke_required:true,
               minlength: 10
          },
          keywords:{                    
                required: true
            },
            titulo:{                    
                required: true,
                 minlength: 10                
            },
            bajada:{                    
                required: true,
                minlength: 10
            },
          categoria: {                    
                required: true
            },
          imagen_interna: {                   
                required: true,
                extension: "jpg,jpeg,png",
                 filesize:{
                  size:120000,
                  kb:120,
                } 
            },
            imagen_cabecera: {                    
                required: true,
                extension: "jpg,jpeg,png",
                callbackTestNuevo: {
                  callbacktest_nuevo: function() {
                    return $imagen_cabecera.data('imageWidth')  == 1170 && $imagen_cabecera.data('imageHeight')  == 450;
                  }
                },               
                filesize:{
                  size:120000,
                  kb:120,
                } 
            },
            imagen_redes: {                   
                required: true,
                extension: "jpg,jpeg,png",
                callbackRedesNuevo: {
                  callbackredes_nuevo: function() {
                  return $imagen_redes.data('imageWidth')  >= 200 && $imagen_redes.data('imageHeight')  >= 200;
                }
              },
              filesize:{
                  size:120000,
                  kb:120,
              }                            
          }
        },
          errorPlacement: function( error, element ) {
            if (element.attr("name") == "categoria"){
              error.insertBefore( element.parent().parent().parent());
            }else{
              error.insertBefore(element);
            }               
    },
    messages: {
        imagen_cabecera: {
          required: "Este campo es obligatorio",
          callbackTestNuevo: "La imágen de cabecera debe tener un tamaño mínimo de 1170px y 450px."
        },
        imagen_redes: {
          required: "Este campo es obligatorio",
          callbackRedesNuevo: "La imágen de cabecera debe tener un tamaño mínimo de 200px y 200px."
        },
        titulo: {
          required: "Este campo es obligatorio"
        },
    },
    submitHandler: function (form){
          var nombre_form=form.name;
      if(nombre_form != ""){
        grabarnuevanoticia(nombre_form);
      }else{
        alert("Lo sentimos, grabe nuevamente");
      }      
    },
    invalidHandler: function (form) {
    } 
    });

     $('#formulario_exitonuevo').validate({
              rules: {
                cuerpo_interno:{
                            cke_required:true
                },
                sector:{                    
                      required: true
                },
                video:{                   
                      required: true
                },
                titulo:{                    
                      required: true,
                      minlength: 10
                },
                imagen_cabecera: {                    
                      required: true,
                      extension: "jpg,jpeg,png",
                      filesize:{
                          size:60000,
                          kb:60,
                      } 
                  }
                },
                errorPlacement: function( error, element ) {
                  if (element.attr("name") == "sector"){
                    error.insertBefore( element.parent().parent().parent());
                  }else{
                    error.insertBefore(element);
                  }
          }
        
          });

      $('#imagen_cabecera').change(function() {
       var fileName = $(this).val();
      $submitBtn.attr('disabled', true);
      $imgContainer_cabe.hide().empty();
      $imagen_cabecera.removeData('imageWidth');
      $imagen_cabecera.removeData('imageHeight');
      var file = this.files[0];
      var id_file3='#imagen_cabecera';
       if(fileName != ""){
         if (file.type.match(/image\/.*/)) {
            var reader = new FileReader();
            reader.onload = function() {
            var $img = $('<img />').attr({ src: reader.result });
           $imgContainer_cabe.append($img).show();
            $img.on('load', function() {
            var imageWidth = $img.width();
            var imageHeight= $img.height();     
            $imagen_cabecera.data('imageWidth', imageWidth);
            $imagen_cabecera.data('imageHeight', imageHeight);
                if (imageWidth != 1170 && imageHeight  != 450) {
                  $imgContainer_cabe.hide();
                }
                $submitBtn.attr('disabled', false);

                $("img").addClass("img-responsive");
                 $imgContainer_cabe.hide();
              });
            }
            reader.readAsDataURL(file);
        }
        } 
    });

    $('#imagen_redes').change(function(e) {
       var fileName = $(this).val();
      $submitBtn.attr('disabled', true);
      $imgContainer_redes.hide().empty();
      $imagen_redes.removeData('imageWidth');
      $imagen_redes.removeData('imageHeight');
      var file = this.files[0];
      if(fileName != ""){
       if (file.type.match(/image\/.*/)) {
            var reader = new FileReader();
            reader.onload = function() {
            var $img = $('<img />').attr({ src: reader.result });
            $imgContainer_redes.append($img).show();
            $img.on('load', function() {
            var imageWidth = $img.width();
            var imageHeight= $img.height();     
            $imagen_redes.data('imageWidth', imageWidth);
            $imagen_redes.data('imageHeight', imageHeight);
                if (imageWidth < 200 && imageHeight  < 200) {
                  $imgContainer_redes.hide();
                }
                $submitBtn.attr('disabled', false);
                $("img").addClass("img-responsive");
                $imgContainer_redes.hide();
              });
            }
            reader.readAsDataURL(file);
          }
        }

    });
    
    $('#formulario_exitoeditar').validate({
      rules: {
          cuerpo_interno:{
              cke_required:true
          },
          sector:{                            
              required: true
          },
          video:{                         
              required: true
          },
          titulo:{                            
              required: true,
              minlength: 10
          },
          imagen_cabecera: {                          
              required: false,
              extension: "jpg,jpeg,png",
              filesize:{
                size:60000,
                kb:60,
              } 
          }
      },
      errorPlacement: function(error,element) {
        if (element.attr("name") == "sector"){
            error.insertBefore( element.parent().parent().parent());
          }else{
            error.insertBefore(element);
        }
      }
    });
});


	



