<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang=""> <!--<![endif]-->
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

  <link rel="shortcut icon" href="img/web/favicons.png">
  <title>AULA MAGNA XXII | PUCP</title>
  <!-- Basic HTML Meta Tags -->
  <meta name='title' content='AULA MAGNA XXII | PUCP' />
  <meta name='description' content='La PUCP organiza anualmente Aula Magna, un espacio internacional de diálogo académico donde se abordan los temas relevantes de nuestro tiempo con el concurso de los mejores especialistas del Perú.' />
  <meta name='url' content='http://www.pucp.edu.pe/aulamagna/' />
  <meta name='keywords' content='PUCP 2018, AULA, MAGNA, AULA MAGNA 2018, LIMA, CIENCIA, TECNOLOGÍA Y DESARROLLO HUMANO' />
  <!-- OpenGraph Meta Tags -->
  <meta property="og:type" content="website" />
  <meta property='og:title' content='AULA MAGNA XXII | PUCP' />
  <meta property='og:description' content='La PUCP organiza anualmente Aula Magna, un espacio internacional de diálogo académico donde se abordan los temas relevantes de nuestro tiempo con el concurso de los mejores especialistas del Perú.' />
  <meta property='og:url' content='http://www.pucp.edu.pe/aulamagna/' />
  <meta property='og:image' content='http://www.pucp.edu.pe/aulamagna/img/aula_magna_2018_fb.jpg' />


  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/main.css">
  <!-- grayscale -->
  <link rel="stylesheet" href="css/grayscale.css">


  <script src="js/vendor/modernizr-2.8.3-respond-1.4.2.min.js"></script>
  <script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-562e7303d204e300" async="async"></script>


  <script>
    (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
    (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
    m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
    })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

    ga('create', 'UA-35984901-1', 'auto');
    ga('require', 'displayfeatures');
    ga('send', 'pageview');
  </script>
</head>
<body>
<!--[if lt IE 8]>
    <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->


<header>
  <div class="container">
    <div class="row">
      <div id="col-logo-pucp" class="col-sm-6 col-sm-push-6 v-align">
        <a href="http://www.pucp.edu.pe" target="_blank">
          <img class="img-responsive pull-right" src="img/web/logo_pucp.jpg" alt="imagen">
        </a>
      </div>

      <div id="viserrectorado" class="col-sm-6 col-sm-pull-6 v-align">
        <a href="http://vicerrectorado.pucp.edu.pe/academico" target="_blank">
          <img class="img-responsive hidden-xs" src="img/web/logo_vicerrectorado.svg" width="113" alt="imagen">
          <img class="img-responsive visible-xs" src="img/web/logo_vicerrectorado_b.svg" width="113" alt="imagen">
        </a>
      </div>
    </div>
  </div>
</header>



<nav class="navbar navbar-default">
  <div class="container">
    <div class="row">
      <!-- Brand and toggle get grouped for better mobile display -->
      <div class="navbar-header">
        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="true">
          <span class="sr-only">Toggle navigation</span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
        </button>
      </div>

      <!-- Collect the nav links, forms, and other content for toggling -->
      <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
        <ul id="menu-principal" class="nav nav-justified">
          <li>
            <a href="#inicio">INICIO</a>
          </li>
           <li>
            <a href="#presentacion">PRESENTACIÓN</a>
          </li>
          <li>
            <a href="#programa">PROGRAMA</a>
          </li>
          <li>                        
            <a href="#expositores">EXPOSITORES</a>
          </li>
          <li>                        
            <a href="#ubicanos">UBÍCANOS</a>
          </li>
          <li>
            <a class="resalte" href="http://campusvirtual.pucp.edu.pe/pucp/procinsc/jsp/Inscripcion.jsp?t=037&i=1876" target="_blank">INSCRÍBETE</a>
          </li>
        </ul>
      </div>
    </div>
  </div>
</nav>


<!-- INICIO -->
<section id="inicio">
  <div class="hidden-xs">
    <video width="100%" height="100%" autoplay muted loop playsinline>
      <source src="videos/pc.mp4" type="video/mp4" codecs="avc1.4D401E, mp4a.40.2">
      <p>Su navegador no soporta la etiqueta de vídeo.</p>
    </video>
  </div>

  <div class="visible-xs-block">
    <img class="img-responsive" style="width:100%;" src="videos/mobil.gif" alt="imagen">
  </div>

  <div class="velo_video"></div>

  <div class="texto-container">
   <div class="texto-table">
      <div class="texto-cell">
        <div class="inline-block">
          <div class="texto-inicio">
            <div class="inline-block linea">AULA MAGNA</div>
            <div class="inline-block linea"> XXII</div>
          </div>

           <div class="texto-abajo">      
            INTELIGENCIA ARTIFICIAL, <i>BIG DATA, MACHINE LEARNING</i> Y ROBÓTICA
          </div>

           <div class="texto-fechas">      
            5, 6 y 7 de NOV.
          </div>
        </div>
      </div>
    </div>
  </div>
</section>



<!-- PRESENTACION -->
<section id="presentacion" class="text-left">
  <div class="container">
    <div class="row">
      <div class="col-sm-7">
        <h2 class="titulo-seccion  color_amarillo">
          DESAFÍOS PARA EL DESARROLLO Y PARA LA UNIVERSIDAD
        </h2>
        
        <p>La PUCP organiza anualmente Aula Magna, un espacio internacional de diálogo académico donde se abordan los temas relevantes de nuestro tiempo con el concurso de los mejores especialistas del Perú y del mundo. Su propósito es ofrecer un examen profundo sobre cada temática abordada, para cumplir con una de las misiones de la universidad: orientar el pensamiento y la reflexión social. Este año, se tratarán temas de frontera: inteligencia artificial, <i>Big Data, Machine Learning</i> y robótica, que ya tienen una enorme influencia en casi todas las actividades humanas y que, en el futuro, serán relevantes en nuestras vidas y sociedades.</p>
        
        <br>
        <a id="btn_seguir" data-toggle="collapse" href="#aula">
           <div class="h4 color_amarillo"><img class="btn-flechas" src="img/web/icon-03.svg" alt="imagen">&nbsp;&nbsp;<strong>SEGUIR LEYENDO</strong></div>          
        </a>
        
        <div id="aula" class="collapse">  
          <p>El desarrollo de las tecnologías informáticas combinadas con diversos usos, productivos, educativos y de investigación, nos está llevando a un nuevo paradigma de desarrollo, y de la organización social y política; asimismo, tiene una enorme influencia en los comportamientos humanos. Es por ello que nos parece necesario presentar el “estado de la cuestión” en estos temas, sus aplicaciones, y perspectivas en el desarrollo y en las universidades.</p>
          <p>En 1956, John McCarthy definió la inteligencia artificial (IA) como “la ciencia e ingenio de hacer máquinas inteligentes, especialmente programas de cómputo inteligentes”. De este modo, se estableció una ruta de investigación computacional cuyos frutos han sido tan impresionantes que hoy buena parte de nuestra vida cotidiana funciona según alguna aplicación de IA. El avance combinado de los programas y de las computadoras ha sido tal que, actualmente, la IA se puede aplicar a casi todos los campos del conocimiento y, en muchos casos, ha reemplazado a la inteligencia humana en varias de sus funciones, lo que obviamente ha comenzado a preocupar. Por ello, Aula Magna quiere tratar este tema, para saber los avances en IA, sus posibilidades futuras, sus amenazas, y cómo podemos servirnos de ella para la educación y el desarrollo humano.</p>
          <p>Asimismo, paralelamente al desarrollo de las tecnologías de la información, o quizás como su resultado, personas e instituciones han generado una gran cantidad de todo tipo de datos -mensajes en Facebook o WhatsApp, observaciones climáticas hechas por máquinas especiales, datos estadísticos sobre cualquier fenómeno o transacciones comerciales y más- que reciben el nombre de Big Data (BD) o datos masivos. Para utilizar esta enorme cantidad de información, se han creado programas informáticos especiales, que permiten investigar todo tipo de problema cualitativo (política, psicología, cultura, etc.), lo que empujará las fronteras del análisis y las investigaciones. Si bien en el Perú estamos recién iniciándonos en el uso del BD para fines prácticos y académicos, obviamente, se abre una caja de Pandora sobre sus posibles usos. </p>
          <p>Si recordamos la serie Perdidos en el espacio, en donde el robot B9 tenía la capacidad de advertir sobre los peligros del entorno, y la comparamos con la nueva en la que el robot no solo camina como un hombre, sino que tiene una fuerza sobrehumana, entiende a su interlocutor y es capaz de planear estrategias, nos encontramos ante la evolución de la máquina que reemplaza al hombre en, casi, todas su funciones. La idea de reemplazar al hombre y a los animales en sus funciones data de épocas anteriores a Cristo, primero como juguetes mecánicos y luego como autómatas, pero es en los últimos cincuenta años que se han desarrollado la ciencia y el arte de construir robots. La robótica es el fruto de la ingeniería mecatrónica (mecánica, electrónica, biomédica e informática), cuyo desarrollo en la industria y los servicios ha comenzado a reemplazar al hombre, pues los robots son capaces de hacer operaciones repetitivas de manera impecable y realizan operaciones más complejas con mayor precisión, por ello, su uso en la medicina, la biología y otras disciplinas científicas ya es la norma que se sigue. Obviamente, la AI ha contribuido enormemente en su producción y funcionamiento, y así puede, eventualmente, reemplazar al hombre. De esta forma, se gesta un nuevo paradigma de desarrollo industrial que se denomina la cuarta revolución industrial.</p>
          <p>En su conjunto, la inteligencia artificial, Big Data, Machine Learning y la robótica están cambiando nuestra forma de vivir e influenciarán en nuestro desarrollo humano, en nuestra educación, en los sistemas de gobierno y administración y, sobre todo, en la vida cotidiana. Por ello, nos parece sumamente importante dedicar esta edición de Aula Magna a este nuevo paradigma del desarrollo.</p>
          <p>Por ese motivo, estamos convocando a los mejores científicos y profesionales internacionales y nacionales para que, a partir de sus propias investigaciones y sus conocimientos, nos puedan ilustrar dónde nos encontramos en estos grandes, cuál es el futuro esperable sobre los desarrollos que se pueden dar, cuáles son las oportunidades, desafíos y amenazas que crea este nuevo entorno tecnológico-informático. Además, se evaluarán los efectos que tendrá sobre la educación en general y, sobre todo, en la educación superior, tanto en la formación como en la investigación. Finalmente, se busca averiguar cuál es el papel y la responsabilidad que deben asumir nuestras universidades especialmente la PUCP.</p>
          <p>Para presentar y debatir sobre estos problemas, el formato de Aula Magna será la del diálogo fluido entre expositores y panelistas. Por todas estas razones, Aula Magna 2018 quiere ser el espacio donde, desde la academia, se analicen estos desafiantes desarrollos científicos tecnológicos. Difundir estos temas es parte de nuestra responsabilidad social como universidad.</p>
          <br>
          <a id="btn_cerrar" data-toggle="collapse" href="#aula">
            <div class="h3 color_amarillo"><img class="btn-flechas" src="img/web/icon-04.svg" alt="imagen">&nbsp;&nbsp;<strong>CERRAR</strong></div>            
          </a>  
        </div>
      </div>
    </div>
  </div>

  <div class="sello"></div>
</section>



<!-- PROGRAMA -->
<section id="programa">
  <div class="container">
    <h2 class="titulo-seccion text-center color_amarillo">PROGRAMA</h2>
    <div id="programa-magna" class="tab-esp">
      <!-- Nav tabs -->
      <ul id="myTab" class="nav nav-tabs nav-justified nav-tabs-sticky">
        <li class="active">
          <a href="#tab-1" data-toggle="tab">
            <div class="tab_rectangular">
              LUNES 5</span>
            </div>
            <span class="pull-right visible-xs"><i class="glyphicon glyphicon-chevron-down"></i></span>
          </a>
        </li>
        <li>
          <a href="#tab-2" data-toggle="tab">
            <div class="tab_rectangular">
              MARTES 6</span>
            </div>
            <span class="pull-right visible-xs"><i class="glyphicon glyphicon-chevron-down"></i></span>
          </a>
        </li>
        <li>
          <a href="#tab-3" data-toggle="tab">
            <div class="tab_rectangular">
              MIÉRCOLES 7</span>
            </div>
            <span class="pull-right visible-xs"><i class="glyphicon glyphicon-chevron-down"></i></span>
          </a>
        </li>
      </ul>

      <!-- Tab panes -->
      <div class="row">
        <div class="col-md-12">

          <div class="tab-content">
            <div role="tabpanel" class="tab-pane fade in active" id="tab-1">
              <div class="panel-body">

                <div class="row">
                  <div class="col-sm-1 hora">18:00</div>
                  <div class="col-sm-11 sub-contenido">
                    <div class="tema color_amarillo"><strong>Inauguración</strong></div>
                    <div class="expositor">Marcial Antonio Rubio Correa, rector de la Pontificia Universidad Católica del Perú</div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-sm-1 hora">18:15</div>
                  <div class="col-sm-11 sub-contenido">
                    <div class="tema color_amarillo"><strong>Algoritmos que aprenden y toman decisiones: desafíos para nuestras sociedades</strong></div>
                      Jorge A. Alvarado (Pontificia Universidad Católica Javeriana, Colombia)<br>
                    <div class="expositor">
                      <dl class="dl-horizontal">
                        <dt><strong>Comentaristas: </strong></dt>
                        <dd>Pablo Quintanilla (Pontificia Universidad Católica del Perú)</dd>
                        <dd>Dante Elías (Pontificia Universidad Católica del Perú)</dd>    
                      </dl>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-sm-1 hora">19:45</div>
                  <div class="col-sm-11 sub-contenido">
                    <div class="tema color_amarillo"><strong>Aprendizaje profundo y visión por computador</strong></div>
                    Petia Radeva (Universidad de Barcelona, España) <br>
                    <div class="expositor">
                      <dl class="dl-horizontal">
                        <dt><strong>Comentaristas: </strong></dt>
                        <dd>Alonso Tenorio (Universidad Peruana Cayetano Heredia)</dd>
                        <dd>Claudia Zapata (Pontificia Universidad Católica del Perú)</dd>    
                      </dl>
                    </div>
                  </div>
                </div>

                <p><strong>Moderador:</strong> Efraín Gonzales de Olarte, vicerrector académico de la PUCP </p>
              </div>
            </div>

            <div role="tabpanel" class="tab-pane fade" id="tab-2">
              <div class="panel-body">

                <div class="row">
                  <div class="col-sm-1 hora">18:00</div>
                  <div class="col-sm-11 sub-contenido">
                    <div class="tema color_amarillo"><strong>Inteligencia artificial y redes neuronales</strong></div>
                    Eduardo Bayro (Instituto Politécnico Nacional, México) <br>
                    <div class="expositor">
                      <dl class="dl-horizontal">
                        <dt><strong>Comentaristas: </strong></dt>
                        <dd>Mirko Zimic (Universidad Peruana Cayetano Heredia)</dd>
                        <dd>Mary Claux (Pontificia Universidad Católica del Perú)</dd>    
                      </dl>
                    </div>                     
                  </div>
                </div>

                <div class="row">
                  <div class="col-sm-1 hora">19:45</div>
                  <div class="col-sm-11 sub-contenido">
                    <div class="tema color_amarillo"><strong>Experiencias sobre robótica y sus aplicaciones </strong></div>
                    Concepción Monje (Universidad Carlos III, España)<br>
                    <div class="expositor">
                      <dl class="dl-horizontal">
                        <dt><strong>Comentaristas: </strong></dt>
                        <dd>Francisco Cuéllar (Pontificia Universidad Católica del Perú)</dd>
                        <dd>Layla Hirsh (Pontificia Universidad Católica del Perú)</dd>    
                      </dl>
                    </div>
                  </div>
                </div>

                <p><strong>Moderador:</strong> Pepi Patrón Costa, vicerrectora de Investigación de la PUCP </p>
              </div>
            </div>

            <div role="tabpanel" class="tab-pane fade" id="tab-3">
              <div class="panel-body">

                <div class="row">
                  <div class="col-sm-1 hora">18:00</div>
                  <div class="col-sm-11 sub-contenido">
                    <div class="tema color_amarillo"><strong>Big Data para empoderar el aprendizaje automático (Machine Learning)</strong></div>
                    César Beltrán (Pontificia Universidad Católica del Perú) <br>
                    <div class="expositor">
                      <dl class="dl-horizontal">
                        <dt><strong>Comentaristas: </strong></dt>
                        <dd>Miguel Rodríguez  (Pontificia Universidad Católica del Perú)</dd>
                        <dd>Carlos Véliz (Pontificia Universidad Católica del Perú)</dd>    
                      </dl>
                    </div>                     
                  </div>
                </div>

                <div class="row">
                  <div class="col-sm-1 hora">19:45</div>
                  <div class="col-sm-11 sub-contenido">
                    <div class="tema color_amarillo"><strong>Las nuevas tecnologías y los desafíos para la universidad </strong></div>
                    Liz Reisberg (Center for International Higher Education at Boston College)<br>
                    <div class="expositor">
                      <dl class="dl-horizontal">
                        <dt><strong>Comentaristas: </strong></dt>
                        <dd>José Espinoza (Universidad Peruana Cayetano Heredia)</dd>
                        <dd>Julio del Valle (Pontificia Universidad Católica del Perú)</dd>    
                      </dl>
                    </div>
                  </div>
                </div>

                <p><strong>Moderador:</strong> Carlos Fosca Pastor, vicerrector administrativo de la PUCP</p>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>


<!-- EXPOSITORES -->
<section id="expositores">
  <div class="container">
    <h2 class="titulo-seccion text-center color_amarillo">EXPOSITORES</h2>

    <div id="myCarousel" class="carousel slide" data-ride="carousel">
      <!-- Indicators -->
      <ol class="carousel-indicators">
        <li data-target="#myCarousel" data-slide-to="0" class="active"></li>
        <li data-target="#myCarousel" data-slide-to="1"></li>
        <li data-target="#myCarousel" data-slide-to="2"></li>
      </ol>

      <!-- Wrapper for slides -->
      <div class="carousel-inner">
        <div class="item active">
          <div class="row">

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_1">
                <div class="contenido_expo">
                  <h3>Jorge Andrés Alvarado</h3>
                  <h4>Pontificia Universidad Católica Javeriana</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4" >
              <div class="figura_expo" data-toggle="modal" data-target="#expo_2">
                <div class="contenido_expo">
                  <h3>Petia Radeva </h3>
                  <h4>Universidad de Barcelona</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_3">
                <div class="contenido_expo">
                  <h3>Eduardo Bayro</h3>
                  <h4>Instituto Politécnico Nacional de México</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

          </div>

          <div class="row">

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_4">
                <div class="contenido_expo">
                  <h3>Concepción Monje </h3>
                  <h4>Universidad Carlos III de Madrid</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_5">
                <div class="contenido_expo">
                  <h3>Liz Reisberg</h3>
                  <h4>Centro para la Educación Superior Internacional - Boston College</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_6">
                <div class="contenido_expo">
                  <h3>Pablo Quintanilla</h3>
                  <h4>Pontificia Universidad Católica del Perú (PUCP)</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>
            
          </div>
        </div>

        <div class="item">
          <div class="row">

            <div class="col-sm-4" data-toggle="modal" data-target="#expo_7">
              <div class="figura_expo" >
                <div class="contenido_expo">
                  <h3>Dante Elías</h3>
                  <h4>Pontificia Universidad Católica del Perú (PUCP)</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_8">
                <div class="contenido_expo">
                  <h3>Alonso Tenorio</h3>
                  <h4>Universidad Peruana Cayetano Heredia</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_9">
                <div class="contenido_expo">
                  <h3>Claudia Zapata</h3>
                  <h4>Pontificia Universidad Católica del Perú (PUCP)</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

          </div>

          <div class="row">

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_10">
                <div class="contenido_expo">
                  <h3>Mirko Zimic</h3>
                  <h4>Universidad Peruana Cayetano Heredia</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_11">
                <div class="contenido_expo">
                  <h3>Mary Claux</h3>
                  <h4>Pontificia Universidad Católica del Perú</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_12">
                <div class="contenido_expo">
                  <h3>Francisco Cuéllar </h3>
                  <h4>Pontificia Universidad Católica del Perú (PUCP)</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

          </div>
        </div>

        <div class="item">
          <div class="row">

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_13">
                <div class="contenido_expo">
                  <h3>Layla Hirsh </h3>
                  <h4>Pontificia Universidad Católica del Perú</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_14">
                <div class="contenido_expo">
                  <h3>César Beltrán</h3>
                  <h4>Pontificia Universidad Católica del Perú</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_15">
                <div class="contenido_expo">
                  <h3>Miguel Rodríguez</h3>
                  <h4>Pontificia Universidad Católica del Perú</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

          </div>

          <div class="row">

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_16">
                <div class="contenido_expo">
                  <h3>Carlos Véliz</h3>
                  <h4>Pontificia Universidad Católica del Perú</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_17">
                <div class="contenido_expo">
                  <h3>José Espinoza</h3>
                  <h4>Universidad Peruana Cayetano Heredia</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

            <div class="col-sm-4">
              <div class="figura_expo" data-toggle="modal" data-target="#expo_18">
                <div class="contenido_expo">
                  <h3>Julio del Valle</h3>
                  <h4>Pontificia Universidad Católica del Perú</h4>
                  <div class="flecha_expo" ><img src="img/flecha_expo.svg"/></div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>

    </div>
  </div>
</section>

<!-- UBICANOS -->
<section id="ubicanos">
  <div class="container">
    <h2 class="titulo-seccion text-center color_amarillo">UBÍCANOS</h2>
  </div>
  <iframe class="mapa"  height="500" src="http://maps.google.es/maps?source=embed&amp;q=auditorio+de+derecho&amp;ie=UTF8&amp;hl=es&amp;view=map&amp;cid=17199463388290660666&amp;hq=auditorio+de+derecho&amp;hnear=&amp;t=m&amp;ll=-12.058795,-77.078619&amp;spn=0.029798,0.046692&amp;z=14&amp;iwloc=A&amp;output=embed"></iframe>
</section>


<footer> 
  <div class="container">
    <div class="row">
      <div class="col-sm-12">
        <div class="compartir">
          <p class="compartir-txt">Comparte este evento:</p>
          <!-- Go to www.addthis.com/dashboard to customize your tools -->
          <div class="addthis_sharing_toolbox"></div>
        </div>
        <br><br>
        <p>© 2018 Pontificia Universidad Católica del Perú - Todos los derechos reservados</p>
        <br>
      </div>
    </div>
  </div>
</footer>





<!-- Modal EXPOSITORES -->
<div id="expo_1" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Jorge Andrés Alvarado<br>Pontificia Universidad Católica Javeriana</h4>
      </div>
      <div class="modal-body">
        <p>
        Ingeniero industrial, M.Sc. en Análisis Masivo de Datos (Analytics) por la North Carolina State University, y doctor en Ingeniería por la Pontificia Universidad Javeriana. Miembro del centro nacional colombiano de Excelencia en Big Data y Data Analytics (Caoba), donde actualmente lidera el proyecto Textolítica del servicio para Bancolombia. Profesor del Departamento de Ingeniería Industrial de la Pontificia Universidad Javeriana y actual director de la Maestría en Analítica para la Inteligencia de Negocios. Consultor en análisis de datos para comportamiento del consumidor. Sus áreas de interés son el procesamiento automático del lenguaje natural (NLP- text mining), los sistemas de soporte a la toma de decisiones (DSS), la analítica predictiva (predictive analytics) y los pronósticos que integran el juicio humano (judgmental forecasting).
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_2" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Petia Radeva <br>Universidad de Barcelona</h4>
      </div>
      <div class="modal-body">
        <p>
        Estudió en la Universidad de Sofía, Bulgaria. En 1993, realizó sus estudios de máster en la Universitat Autònoma de Barcelona en el campo del procesamiento de imágenes, gráficos por ordenador e inteligencia artificial. En 1996, se recibió como Ph.D. por la Universitat Autònoma de Barcelona. Actualmente, trabaja en el Departamento de Matemáticas Aplicadas y Análisis de dicha universidad, y es jefe del Laboratorio de Imágenes Médicas (MILab) del Centro de Visión por Computadora (www.cvc.uab.es). Sus intereses de investigación actuales se centran en el desarrollo de enfoques basados en el aprendizaje para la visión por computadora y el procesamiento de imágenes; así como también los de lifelogging y visión egocéntrica, detección de eventos, descubrimiento de objetos, segmentación y análisis de video, segmentación de imagen y clasificación de clase múltiple.
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_3" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Eduardo Bayro<br>Instituto Politécnico Nacional de México</h4>
      </div>
      <div class="modal-body">
        <p>
        Ingeniero electrónico con mención en Telecomunicaciones. Obtuvo su Doctorado en Ciencias de la Computación por la Universidad de Wales, College of Carddiff (Reino Unido, 1993). Su especialización son los sistemas cognitivos, lo que lo llevó a profundizar sus conocimientos sobre la inteligencia artificial y a despertar su pasión por la robótica humanoide. Es miembro del SIN Nivel III y sus líneas de investigación son la aplicación de álgebras geométricas de Clifford a sistemas cognitivos, computación industrial, visión computacional, robots móviles, redes neuronales geométricas, wavelets, neurocomputación, y  procesamiento y análisis de imágenes de color. Es profesor de Computación Geométrica en el  Centro de Investigación y de Estudios Avanzados (Cinvestav) del Instituto Politécnico Nacional de México.
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_4" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Concepción Monje <br>Universidad Carlos III de Madrid</h4>
      </div>
      <div class="modal-body">
        <p>
       Investigadora en robótica y profesora titular de la Universidad Carlos III de Madrid, donde actualmente desarrolla su labor investigadora en el grupo RoboticsLab. Doctora por la Universidad de Extremadura en 2006. Ha colaborado activamente con centros de investigación internacionales de Estados Unidos, Francia y Alemania, y dirige actualmente varios proyectos sobre el desarrollo de robots asistenciales. 
        </p>

        <p>
        Trabaja desde hace más de una década en torno al robot humanoide TEO, un robot bípedo, de tamaño y peso humano, concebido como un robot asistencial que permite la mejora de la calidad de vida de las personas. Este trabajo le ha permitido recibir una serie de distinciones y premios. Es, además, una científica muy comprometida con la visibilidad del papel de la mujer en la ciencia y la tecnología, la docencia universitaria y la divulgación científica. 
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_5" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Liz Reisberg<br>Centro para la Educación Superior Internacional - Boston College</h4>
      </div>
      <div class="modal-body">
        <p>
        Es una consultora internacional que trabaja en proyectos relacionados con la mejora de la educación superior. Ha trabajado con gobiernos, universidades y agencias donantes internacionales. Los temas de su investigación y otras actividades incluyen el aseguramiento de la calidad en la educación superior, los desafíos del acceso y la equidad, así como nuevos enfoques del currículo y la pedagogía universitaria. Tiene más de tres décadas de experiencia trabajando en admisiones universitarias y en la capacitación de profesionales de admisión. 
        </p>
        <p>
        Su emprendimiento empresarial, The MBA Tour, capacitó y apoyó a generaciones de directores de admisiones de MBA de muchas de las escuelas de negocios más conocidas del mundo para desarrollar oportunidades en América Latina, Asia y Medio Oriente. Su experiencia más reciente ha sido la colaboración con socios internacionales para diseñar, reunir a profesores expertos y ofrecer talleres sobre temas relacionados con las tendencias internacionales en la educación superior. 
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_6" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Pablo Quintanilla<br>Pontificia Universidad Católica del Perú (PUCP)</h4>
      </div>
      <div class="modal-body">
        <p>
        Ph.D. en Filosofía por la Universidad de Virginia y magíster en Filosofía por la Universidad de Londres (King's College). Se especializa en filosofía del lenguaje y de la mente, epistemología y teoría de la acción. Es coeditor de El pensamiento pragmatista en la actualidad (2015), Pedro Zulen: escritos reunidos (2015), Cognición social y lenguaje. La intersubjetividad en la evolución de la especie y en el desarrollo del niño (2014), Lógica, lenguaje y mente (2011), Desarrollo humano y libertades. Una aproximación interdisciplinaria (2009). Es editor de Ensayos de metafilosofía (2009), y coautor de Pensamiento y acción. La filosofía peruana a comienzos del siglo XX (2009) y de ¿Un mundo sin certezas? (1997).
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_7" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Dante Elías<br>Pontificia Universidad Católica del Perú (PUCP)</h4>
      </div>
      <div class="modal-body">
        <p>
        Doctor en Ciencias de la Ingeniería por la Universidad Católica de Chile e ingeniero mecánico por la Pontificia Universidad Católica del Perú. Docente e investigador a tiempo completo (categoría Principal) de la Sección Ingeniería Mecánica de la PUCP. Director de Investigación de la Sección Ingeniería Mecánica de la PUCP y de la Maestría en Ingeniería Mecánica de la PUCP. Ganador del Premio Nacional Sinacyt 2014 a la Innovación, y del Premio a la Investigación 2009 y 2011 en la PUCP. Ha realizado investigaciones y publicaciones sobre biomecánica y robótica aplicada a la discapacidad motriz, la rehabilitación física, y el entrenamiento de deportistas o de pilotos en general, a través de proyectos financiados por FINCyT, Fidecom, Concytec y PUCP.
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_8" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Alonso Tenorio<br>Universidad Peruana Cayetano Heredia</h4>
      </div>
      <div class="modal-body">
        <p>
        Profesional en Ingeniería Informática con una Maestría en Tecnologías Informáticas Avanzadas de la Universidad Castilla La Mancha (España). Dentro de su experiencia académica se desempeñó como docente auxiliar en la Escuela Politécnica Superior de Ingeniería Informática de la UCLM (España). Ha trabajado en la Dirección Universitaria de Informática de la Universidad Peruana Cayetano Heredia administrando servidores, como máquinas virtuales en entornos Linux, y estableciendo soluciones de seguridad informática.
        </p>
        <p>
        Actualmente, es director del Centro de Tecnologías de la Información y Comunicaciones de la Universidad Nacional de Ingeniería y jefe del laboratorio de Cloud Computing del CTIC UNI. Dentro de sus líneas de investigación, trabaja en proyectos de mejoramiento del tráfico, soluciones de cloud computing, big data & HPC, como agricultura de precisión. Se ha especializado en administración de servidores y máquinas virtuales con Linux, y en tecnologías, como cloud computing, cluster, grid computing, big data, SDN, internet of things y algoritmos paralelos.
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_9" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Claudia Zapata<br>Pontificia Universidad Católica del Perú (PUCP)</h4>
      </div>
      <div class="modal-body">
        <p>
        Magíster en Ciencia de la Computación por la Pontificia Universidad Católica del Perú. Su tesis de magíster, “Análisis del tamaño de la muestra en una evaluación heurística de usabilidad”, revisa los resultados de un caso práctico sobre la cantidad válida de usuarios con los cuales se puede realizar una evaluación heurística. Es miembro investigador del Grupo de Investigación Avatar-PUCP, y del Grupo de Investigación de Usabilidad y Métricas de Software-PUCP. Líder del equipo de desarrollo de videojuegos por el bicentenario (creados por el grupo Avatar-PUCP): 1814: la rebelión del Cuzco y Mariano: el último sueño. Asesora de usabilidad de proyectos de distintos grupos de investigación de la PUCP. Su experiencia profesional se centra en el diseño y evaluación de interfaces usables y accesibles, y en la gestión de proyectos de desarrollo de software y de soluciones aplicadas al aprendizaje mediante videojuegos.      
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_10" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Mirko Zimic<br>Universidad Peruana Cayetano Heredia</h4>
      </div>
      <div class="modal-body">
        <p>
        Ph.D. en Control y Prevención de Enfermedades por la Universidad Johns Hopkins, M.Sc. en Bioquímica por la Universidad Peruana Cayetano Heredia y B.Sc. en Física por la Universidad Nacional de Ingeniería. Actualmente, se desempeña como jefe del Laboratorio de Bioinformática y Biología Molecular de la UPCH, y lidera un grupo de trabajo multidisciplinario, por lo que investiga en distintas áreas de ciencia y tecnología. Gracias al financiamiento del Programa de Ciencia y Tecnología y el Concytec, ha desarrollado un sistema de telediagnóstico de tuberculosis aplicando la microbiología, el tratamiento de imágenes y las tecnologías avanzadas de telecomunicaciones. Este sistema fue replicado y logró desarrollar una plataforma de telediagnóstico de melanoma y cáncer de cuello uterino. 
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_11" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Mary Claux<br>Pontificia Universidad Católica del Perú</h4>
      </div>
      <div class="modal-body">
        <p>
        Doctora en Ciencias Sociales con mención en Psicología por la Universidad de Radboud, Nimega, Países Bajos (antes Universidad Católica de Nimega). Psicóloga educacional, graduada y licenciada por la Universidad Peruana Cayetano Heredia. Sus intereses de investigación se orientan hacia el estudio de factores que afectan el desempeño académico y el desarrollo psicológico, en especial en la población escolar adolescente. Recientemente, ha estudiado sobre procesos de autorregulación, motivación y esfuerzo en el comportamiento académico, así como influencias del entorno en la formación de orientaciones de metas en jóvenes. Ha desarrollado herramientas de evaluación de procesos básicos y promoción de competencias de lectura.
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_12" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Francisco Cuéllar <br>Pontificia Universidad Católica del Perú (PUCP)</h4>
      </div>
      <div class="modal-body">
        <p>
       Ingeniero electrónico por la PUCP y máster en Mecatrónica por la Kings College University of London. También es máster en Gestión y Política de Innovación y Tecnología por la PUCP y Ph.D. (c) en Robotic Intelligent Systems por la Universidad de Osaka. Cofundador de la startup Qaira, drones para monitorear la calidad del aire; y es CEO de 4Helix Labs, robots para monitoreo e inspección en la industria. Asimismo, desarrolla proyectos disruptivos de ciencia, tecnología e innovación con la industria y la academia. Tiene una sólida y reconocida experiencia en las industrias minera, metalmecánica, de seguridad, telecomunicaciones, salud y educación. Actualmente, es profesor asociado de la Pontificia Universidad Católica del Perú, y director del Programa de Maestría en Control y Automatización de la misma universidad. También es fundador del Grupo de Investigación de Tecnología Innovadora en la PUCP, que ejecuta proyectos de innovación financiados por el gobierno para la industria, publica documentos científicos y genera propiedad intelectual. 
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_13" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Layla Hirsh <br>Pontificia Universidad Católica del Perú</h4>
      </div>
      <div class="modal-body">
        <p>
      Investigadora de Concytec. Doctora en Biociencia y Biotecnología por la Universidad de Padua, Italia. Ingeniera informática con Maestría en Ciencias de la Computación. Profesora asociada de la Pontificia Universidad Católica del Perú desde el 2008; colabora con laboratorios de investigación en Argentina, Italia, Alemania, Francia y Serbia, entre otros. Cuenta con publicaciones en revistas de alto impacto, como Nucleic Acids Research y Bioinformatics. Su investigación se centra en estructuras repetitivas de proteínas y ha desarrollado un predictor para unidades repetidas que usó para actualizar RepeatsDB, una base de datos de estructuras de proteína repetidas. 
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_14" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">César Beltrán <br>Pontificia Universidad Católica del Perú (PUCP)</h4>
      </div>
      <div class="modal-body">
        <p>
       Doctor en Bioinformática por la Universidad de Sao Paulo, Brasil. Su tesis “Análisis de Formas Biológicas para el Diagnóstico Automático” fue desarrollada en el Grupo de Visión Cibernética y el laboratorio de Biología Molecular de la Universidad de Sao Paulo. Es graduado en Ingeniería de Sistemas por la Universidad Católica Santa María, Arequipa. Fue docente de la UCSM y UNSA de Arequipa. Ha desarrollado diversos proyectos de innovación tecnológica, por lo que ha obtenido varios reconocimientos.
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_15" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Miguel Rodríguez <br>Pontificia Universidad Católica del Perú (PUCP)</h4>
      </div>
      <div class="modal-body">
        <p>
       Ph.D. y M.A. en Lingüística Teórica por la Universidad de Connecticut, M.A. en Lingüística Hispana por la Universidad de Arizona, y licenciado y bachiller en Lingüística y Literatura por la PUCP. Fue profesor de la Sección de Lingüística y Literatura en la PUCP entre 1992-2000, y de Lingüística Hispánica en la Universidad de Indiana (Bloomington) hasta el 2012, cuando se reincorporó a la PUCP. 
        </p>
        <p>
        Sus intereses de investigación están centrados en la teoría gramatical, en particular, la distribución, configuración, interpretación y adquisición de las estructuras nominales, la sintaxis del evento, y la relación entre sintaxis y discurso. Sus áreas de interés incluyen también las interfaces, la filosofía del lenguaje y de la mente, la relación entre lenguaje, poder e ideología, y la sintaxis del castellano en contacto con lenguas andinas y amazónicas.
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_16" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Carlos Véliz <br>Pontificia Universidad Católica del Perú (PUCP)</h4>
      </div>
      <div class="modal-body">
        <p>
       Doctor en Ciencias por la Pontificia Universidad Católica del Perú y en Ingeniería Industrial por la Universidad Nacional Mayor de San Marcos; además tiene una Maestría en Matemáticas por la PUCP. Cuenta también con estudios en Estadística Matemática en la Universidad de Grenoble, Francia. Respecto a su experiencia profesional, es consultor en análisis de datos y modelos estadísticos en general para diversas entidades privadas y públicas. También ha realizado asesorías para diversas empresas, como Booz Allen, Hamilton del Perú S.A., Banco Mundial, SBS, ONP, entre otras. Es especialista en análisis de datos, desarrollo de modelos estadísticos y desarrollo de modelos actuariales. Actualmente, es profesor en el área académica de Operaciones, Logística y Tecnología en Centrum Católica Graduate Business School.
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_17" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">José Espinoza <br>Universidad Peruana Cayetano Heredia</h4>
      </div>
      <div class="modal-body">
        <p>
       Biólogo que cuenta con una Maestría en Ciencias con mención en Bioquímica por la Universidad Peruana Cayetano Heredia y doctor en Molecular Genetics en la University of Cambridge, Reino Unido. Profesor principal y, actualmente, director de la Escuela de Posgrado Víctor Alzamora Castro de la Universidad Peruana Cayetano Heredia. Sus intereses científicos se dirigen al estudio de la variabilidad genética humana en la enfermedad y adaptación a la altura, la genómica de la biodiversidad aplicable a su conservación y mapeo de loci asociados a caracteres productivos, y la generación de nuevas tecnologías aplicadas al diagnóstico y tratamiento de enfermedades. 
        </p>
      </div>

    </div>
  </div>
</div>

<div id="expo_18" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Julio del Valle <br>Pontificia Universidad Católica del Perú (PUCP)</h4>
      </div>
      <div class="modal-body">
        <p>
       Doctor en Filosofía por la Ruprecht-Karls Universität (Heidelberg, Alemania), especializado en Estética y Filosofía del Arte. Tiene estudios complementarios de Germanística y Didáctica en la misma universidad. Profesor asociado del Departamento de Humanidades, Especialidad de Filosofía, de la Pontificia Universidad Católica del Perú. Ha sido director de Estudios en Estudios Generales Letras de la PUCP, y es profesor de los cursos de Filosofía del Arte, Estética, Filosofía Antigua e Investigación Académica.
        </p>
      </div>

    </div>
  </div>
</div>





<script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>
<script>window.jQuery || document.write('<script src="js/vendor/jquery-1.11.2.min.js"><\/script>')</script>
<script src="js/vendor/bootstrap.min.js"></script>

<!-- grayscale -->
<script src="js/grayscale.js"></script>

<!-- Bootstrap TabCollapse-->
<script src="js/bootstrap-tabcollapse.js"></script>
<!-- stickytabs -->
<script src="js/jquery.stickytabs.js"></script>
<script>
  $('#myTab').tabCollapse();
  $('#myTab').stickyTabs();
</script>

<!-- main.js -->
<script src="js/main.js"></script>

</body>
</html>
